/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.FeatRuntimeException;
import feat2.StringUtil;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.DIComponentConfig;
import feat2.config.FeatureConfig;
import feat2.config.InputConfigBase;
import feat2.config.InputSupport;
import feat2.config.ValidatableComponentConfig;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;
import feat2.validation.ByteValidator;
import feat2.validation.CreditCardValidator;
import feat2.validation.DateValidator;
import feat2.validation.DoubleValidator;
import feat2.validation.FileTypeValidator;
import feat2.validation.FloatValidator;
import feat2.validation.IntValidator;
import feat2.validation.LengthValidator;
import feat2.validation.LongValidator;
import feat2.validation.MailAddressValidator;
import feat2.validation.NumberRangeValidator;
import feat2.validation.PostalCodeValidator;
import feat2.validation.RequiredValidator;
import feat2.validation.ShortValidator;
import feat2.validation.SimpleDateValidator;
import feat2.validation.StringValidator;
import feat2.validation.Validator;

public class ValidationConfig
extends Config
implements DIComponentConfig {
    private Identifier name;
    private String propertyList;
    private String type;
    private JavaIdentifier className;
    private String dependList;
    private String messageId;
    private InputSupport inputs = new InputSupport(this);
    private Class validatorClass;
    private ValidationConfig[] depends;
    private JavaIdentifier[] properties;

    public JavaIdentifier getClassName() {
        return this.className;
    }

    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public ValidationConfig[] getDepends() {
        return this.depends;
    }

    public void setDependList(String dependList) {
        this.dependList = dependList;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public JavaIdentifier[] getProperties() {
        return this.properties;
    }

    public void setProperties(JavaIdentifier[] properties) {
        this.properties = properties;
    }

    public void setPropertyList(String propertyList) {
        this.propertyList = propertyList;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Validator getValidatorInstance() {
        Validator validator = null;
        try {
            validator = (Validator)this.validatorClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new FeatRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new FeatRuntimeException(ex);
        }
        return validator;
    }

    public void addInput(InputConfigBase input) {
        this.inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return this.inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return this.inputs.getInputConfig(propertyName);
    }

    public String getElementName() {
        return "validation";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        FeatureConfig featureConf = this.getFeatureConfig();
        ret = ret && ConfigUtil.validateRequired(this.name, "name", this, errs);
        ret = ret && ConfigUtil.validateRequired(this.propertyList, "properties", this, errs);
        boolean bl = ret = ret && ConfigUtil.validateRequired(this.type, "type", this, errs);
        if (this.propertyList != null) {
            String[] nameList = StringUtil.split(this.propertyList);
            this.properties = new JavaIdentifier[nameList.length];
            for (int i = 0; i < nameList.length; ++i) {
                this.properties[i] = new JavaIdentifier(nameList[i]);
            }
        }
        if (this.getType().equalsIgnoreCase("class")) {
            this.validatorClass = ConfigUtil.validateClass(this.className, "class", this, errs);
            if (this.validatorClass == null) {
                ret = false;
            }
        } else if (this.type.equalsIgnoreCase("byte")) {
            this.validatorClass = ByteValidator.class;
        } else if (this.type.equalsIgnoreCase("short")) {
            this.validatorClass = ShortValidator.class;
        } else if (this.type.equalsIgnoreCase("int")) {
            this.validatorClass = IntValidator.class;
        } else if (this.type.equalsIgnoreCase("long")) {
            this.validatorClass = LongValidator.class;
        } else if (this.type.equalsIgnoreCase("float")) {
            this.validatorClass = FloatValidator.class;
        } else if (this.type.equalsIgnoreCase("double")) {
            this.validatorClass = DoubleValidator.class;
        } else if (this.type.equalsIgnoreCase("string")) {
            this.validatorClass = StringValidator.class;
        } else if (this.type.equalsIgnoreCase("required")) {
            this.validatorClass = RequiredValidator.class;
        } else if (this.type.equalsIgnoreCase("range")) {
            this.validatorClass = NumberRangeValidator.class;
        } else if (this.type.equalsIgnoreCase("length")) {
            this.validatorClass = LengthValidator.class;
        } else if (this.type.equalsIgnoreCase("date")) {
            this.validatorClass = DateValidator.class;
        } else if (this.type.equalsIgnoreCase("simple-date")) {
            this.validatorClass = SimpleDateValidator.class;
        } else if (this.type.equalsIgnoreCase("mail-address")) {
            this.validatorClass = MailAddressValidator.class;
        } else if (this.type.equalsIgnoreCase("postal-code")) {
            this.validatorClass = PostalCodeValidator.class;
        } else if (this.type.equalsIgnoreCase("credit-card")) {
            this.validatorClass = CreditCardValidator.class;
        } else if (this.type.equalsIgnoreCase("filetype")) {
            this.validatorClass = FileTypeValidator.class;
        } else {
            errs.add(new ConfigError(this.type, "error.config.validation.type", 10, this));
        }
        ValidatableComponentConfig parent = (ValidatableComponentConfig)((Object)this.getParent());
        if (this.dependList != null) {
            String[] elements = StringUtil.split(this.dependList);
            this.depends = new ValidationConfig[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                this.depends[i] = parent.getValidationConfig(elements[i]);
                if (this.depends[i] != null) continue;
                errs.add(new ConfigError(elements[i], "depends", "referrence.validation", 10, this));
            }
        } else {
            this.depends = new ValidationConfig[0];
        }
        ret = ret && this.inputs.validate(errs);
        return true;
    }
}

