/*
 * Decompiled with CFR 0.152.
 */
package feat2.config.type;

import feat2.validation.ValidatorUtil;
import java.util.regex.Pattern;

public class Identifier {
    private String value;
    private static Pattern identifierPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");

    public Identifier() {
        this.value = null;
    }

    public Identifier(String identifier) throws IllegalArgumentException {
        if (!Identifier.isIdentifier(identifier)) {
            throw new IllegalArgumentException();
        }
        this.value = identifier;
    }

    public boolean equals(Object obj) {
        return this.value.equals(((Identifier)obj).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean isIdentifier(String string) {
        if (ValidatorUtil.isBlankOrNull(string)) {
            return false;
        }
        return identifierPattern.matcher(string).matches();
    }
}

