/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Cache {
    private HashMap buf = new HashMap();
    private long cleanTime = 0L;
    private long cleanupTotalTime;
    private int hits;
    private int requests;
    private int putCount;
    private int cleanCount;
    private long startTime = System.currentTimeMillis();

    public synchronized void put(Object key, Object obj, long ttl) {
        CacheEntry entry = new CacheEntry(obj, ttl);
        this.buf.put(key, entry);
        if (++this.putCount >= 10000) {
            this.clean(1000L, 10000L);
            this.putCount = 0;
        }
    }

    public synchronized void remove(Object key) {
        this.buf.remove(key);
    }

    public synchronized Object get(Object key) {
        ++this.requests;
        CacheEntry entry = (CacheEntry)this.buf.get(key);
        if (entry != null) {
            Object ret = entry.get();
            if (ret == null) {
                this.buf.remove(key);
            } else {
                ++this.hits;
            }
            return ret;
        }
        return null;
    }

    public synchronized void clean(long interval, long limit) {
        if (this.cleanTime + interval < System.currentTimeMillis()) {
            long start = System.currentTimeMillis();
            ArrayList removeList = new ArrayList();
            Iterator it = this.buf.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                CacheEntry entry = (CacheEntry)this.buf.get(key);
                if (entry != null) {
                    Object obj = entry.get();
                    if (obj == null) {
                        removeList.add(key);
                    }
                    if (start + limit >= System.currentTimeMillis()) continue;
                    break;
                }
                removeList.add(key);
            }
            for (int i = 0; i < removeList.size(); ++i) {
                this.buf.remove(removeList.get(i));
            }
            this.cleanTime = System.currentTimeMillis();
            this.cleanupTotalTime += this.cleanTime - start;
            ++this.cleanCount;
        }
    }

    public synchronized String getCacheStatus() {
        long running = System.currentTimeMillis() - this.startTime;
        int alive = 0;
        int purged = 0;
        int expired = 0;
        int empty = 0;
        Iterator it = this.buf.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            CacheEntry entry = (CacheEntry)this.buf.get(key);
            if (entry == null) {
                ++empty;
                continue;
            }
            if (entry.isPurged()) {
                ++purged;
                continue;
            }
            if (entry.isExpired()) {
                ++expired;
                continue;
            }
            ++alive;
        }
        int rate = this.requests > 0 ? this.hits * 100 / this.requests : 0;
        return "entries " + this.buf.size() + " : alive " + alive + " : purged " + purged + " : expired " + expired + " : requests " + this.requests + " : hits " + this.hits + " : rate " + rate + " : clean " + this.cleanCount + " : clean up time " + this.cleanupTotalTime + "ms" + " : running time " + running / 3600000L + "h (" + running / 60000L + "m)";
    }

    private class CacheEntry {
        private long time;
        private long ttl;
        private SoftReference ref;

        private CacheEntry(Object obj, long ttl) {
            this.ref = new SoftReference<Object>(obj);
            this.ttl = ttl;
            this.time = System.currentTimeMillis();
        }

        private boolean isExpired() {
            return this.time + this.ttl < System.currentTimeMillis();
        }

        private boolean isPurged() {
            return this.ref.get() == null;
        }

        private Object get() {
            if (this.time + this.ttl < System.currentTimeMillis()) {
                return null;
            }
            return this.ref.get();
        }
    }
}

