/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.Action;
import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FileUploadException;
import feat2.Interceptor;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.ValidationError;
import feat2.config.ActionConfigBase;
import feat2.config.BeanConfig;
import feat2.config.CommandConfig;
import feat2.config.FetchConfig;
import feat2.config.InterceptConfig;
import feat2.config.OutputConfig;
import feat2.config.type.Scope;
import java.util.ArrayList;
import java.util.Map;

public class Command {
    private CommandConfig config;

    public Command(CommandConfig config) {
        this.config = config;
    }

    public String execute(CommandContext ctx) throws PropertyAccessException, ApplicationException, FileUploadException {
        int i;
        ActionConfigBase[] actionConfs = this.config.getActions();
        String ret = null;
        Interceptor[] interceptors = this.selectInterceptors();
        for (i = 0; i < interceptors.length; ++i) {
            interceptors[i].before(this, ctx);
        }
        for (i = 0; i < actionConfs.length; ++i) {
            ret = this.processAction(actionConfs[i], ctx);
            if (ret == null) continue;
            return ret;
        }
        ret = this.processOutput(ctx);
        for (i = 0; i < interceptors.length; ++i) {
            interceptors[i].after(this, ctx);
        }
        return ret;
    }

    private String processAction(ActionConfigBase actionConf, CommandContext ctx) throws PropertyAccessException, FileUploadException, ApplicationException {
        Object result;
        String actionName = actionConf.getName().getValue();
        Map sourceValues = Processor.processInputs(actionConf, ctx);
        long ttl = 0L;
        ActionCacheKey key = new ActionCacheKey(ctx.getFeatureName(), ctx.getCommandName(), actionName, sourceValues);
        if (actionConf instanceof FetchConfig) {
            ttl = ((FetchConfig)actionConf).getCache();
        }
        if (ttl > 0L && (result = ctx.getCacheObject(key)) != null) {
            ctx.setAttribute(actionName, result);
            return null;
        }
        Action action = actionConf.getActionInstance();
        Object bean = action;
        if (action instanceof BeanConfig.BeanAction) {
            bean = ((BeanConfig.BeanAction)action).getBean(ctx);
        }
        if (!Processor.processValidations(bean, sourceValues, actionConf, ctx)) {
            return actionConf.getErrorResponse().getValue();
        }
        Processor.processInjection(bean, sourceValues);
        if (ctx.getFeatErrors().getErrors(ValidationError.class).length == 0) {
            try {
                result = action.execute(ctx);
            }
            catch (Exception ex) {
                throw new ApplicationException(ex);
            }
            ctx.setAttribute(actionName, result);
            if (ttl > 0L) {
                ctx.putCacheObject(key, result, ttl);
            }
        }
        return null;
    }

    private Interceptor[] selectInterceptors() {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        InterceptConfig[] interceptConfs = this.config.getFeatureConfig().getInterceptConfigs();
        block0: for (int i = 0; i < interceptConfs.length; ++i) {
            String[] patterns = interceptConfs[i].getPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                if (!this.config.getName().getValue().matches(patterns[j])) continue;
                Interceptor interceptor = interceptConfs[i].getInterceptorInstance();
                interceptors.add(interceptor);
                continue block0;
            }
        }
        return interceptors.toArray(new Interceptor[interceptors.size()]);
    }

    private String processOutput(CommandContext ctx) {
        OutputConfig outputConf;
        String name = ctx.getOutputName();
        if (name == null) {
            name = "default";
        }
        if ((outputConf = this.config.getOutputConfig(name)) == null) {
            return null;
        }
        String responseName = outputConf.getResponse().getValue();
        OutputConfig.Mapping[] outputMappings = outputConf.getOutputMapping();
        for (int i = 0; i < outputMappings.length; ++i) {
            Object local = ctx.getAttribute(outputMappings[i].getLocalName());
            Scope scope = outputMappings[i].getScope();
            if (scope == null && (scope = outputConf.getScope()) == null) {
                scope = new Scope("request");
            }
            ctx.setAttribute(outputMappings[i].getOutputName(), local, scope);
        }
        return responseName;
    }

    public CommandConfig getConfig() {
        return this.config;
    }

    private class ActionCacheKey {
        private Map params;
        private String actionName;
        private String featureName;
        private String commandName;

        ActionCacheKey(String featureName, String commandName, String actionName, Map params) {
            this.featureName = featureName;
            this.commandName = commandName;
            this.actionName = actionName;
            this.params = params;
        }

        public int hashCode() {
            return this.featureName.hashCode() ^ this.commandName.hashCode() ^ this.actionName.hashCode() ^ ((Object)this.params).hashCode();
        }

        public boolean equals(Object o) {
            ActionCacheKey k = (ActionCacheKey)o;
            return this.featureName.equals(k.featureName) && this.commandName.equals(k.commandName) && this.actionName.equals(k.actionName) && ((Object)this.params).equals(k.params);
        }
    }
}

