/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FeatRuntimeException;
import feat2.FileDownload;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.TemplateParsingException;
import feat2.config.FileConfig;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.codec.net.URLCodec;

public class FileDownloadResponse
implements Response {
    private static final int MSIE = 0;
    private static final int FIREFOX = 1;
    private static final int MOZILLA = 2;
    private static final int OPERA = 3;
    private static final int SAFARI = 4;
    private static final int MSIE_MAC = 5;
    private FileDownload downloadSource;
    private FileConfig config;

    public FileDownloadResponse(FileDownload downloadSource, FileConfig config) {
        this.downloadSource = downloadSource;
        this.config = config;
    }

    public String output(CommandContext ctx) throws IOException, PropertyAccessException, TemplateParsingException, ServletException, ApplicationException, FileUploadException {
        Map inputValues = Processor.processInputs(this.config, ctx);
        if (!Processor.processValidations(this.downloadSource, inputValues, this.config, ctx)) {
            return this.config.getErrorResponse().getValue();
        }
        Processor.processInjection(this.downloadSource, inputValues);
        this.setHeader(ctx);
        this.write(ctx);
        return null;
    }

    private int getUaType(CommandContext ctx) {
        String ua = ctx.getRequest().getHeader("User-Agent");
        int uaType = 0;
        if (ua != null) {
            if (ua.indexOf("Opera") > -1) {
                uaType = 3;
            } else if (ua.indexOf("Firefox") > -1) {
                uaType = 1;
            } else if (ua.indexOf("Safari") > -1) {
                uaType = 4;
            } else if (ua.indexOf("Gecko") > -1) {
                uaType = 2;
            } else if (ua.indexOf("MSIE") > -1) {
                uaType = 0;
                if (ua.indexOf("Mac") > -1) {
                    uaType = 5;
                }
            }
        }
        return uaType;
    }

    private void setHeader(CommandContext ctx) {
        String mimeType;
        HttpServletResponse resp = ctx.getResponse();
        String fileName = this.downloadSource.getFileName();
        if (fileName == null) {
            fileName = this.config.getFilename();
        }
        if ((mimeType = this.downloadSource.getMimeType()) == null) {
            mimeType = this.config.getContentType();
        }
        if (fileName != null) {
            try {
                int ua = this.getUaType(ctx);
                if (ua == 0) {
                    URLCodec enc = new URLCodec("UTF-8");
                    String encodedFileName = enc.encode(fileName);
                    resp.setHeader("Content-Disposition", "attachment;filename=\"" + encodedFileName + "\"");
                } else if (ua == 1 || ua == 2) {
                    BCodec enc = new BCodec("UTF-8");
                    String encodedFileName = enc.encode(fileName);
                    resp.setHeader("Content-Disposition", "attachment;filename=\"" + encodedFileName + "\"");
                } else {
                    resp.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
                }
            }
            catch (EncoderException ex) {
                throw new FeatRuntimeException(ex);
            }
        }
        if (mimeType != null) {
            resp.setContentType(mimeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(CommandContext ctx) throws IOException, ApplicationException {
        try {
            BufferedInputStream is = new BufferedInputStream(this.downloadSource.getInputStream(ctx));
            try {
                int size;
                ServletOutputStream os = ctx.getResponse().getOutputStream();
                byte[] buf = new byte[512];
                while ((size = ((InputStream)is).read(buf)) > 0) {
                    os.write(buf, 0, size);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }
}

