/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.StringUtil;
import feat2.TemplateParsingException;
import feat2.config.FileLocator;
import feat2.template.HTMLAttribute;
import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.HTMLTemplate;
import feat2.template.HTMLTemplateParser;
import feat2.template.NodeNotFoundException;
import feat2.template.RemarkTextException;
import feat2.template.impl.HTMLElementImpl;
import feat2.template.impl.HTMLNodeImpl;
import feat2.template.impl.HTMLRemarkImpl;
import feat2.template.impl.HTMLTemplateImpl;
import feat2.template.impl.HTMLTextImpl;
import feat2.template.impl.HTMLValuedAttribute;
import feat2.template.impl.HTMLWhitespaceAttribute;
import feat2.template.impl.TemplateUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class HTMLParser15TemplateParser
implements HTMLTemplateParser {
    private static Log log = LogFactory.getLog((Class)HTMLElementImpl.class);

    public HTMLTemplate parseTemplate(FileLocator loc, String encoding) throws TemplateParsingException, IOException {
        return this.parse(loc, encoding);
    }

    private HTMLTemplateImpl parse(FileLocator loc, String encoding) throws TemplateParsingException, IOException {
        HTMLTemplateImpl template = null;
        try {
            Parser parser;
            String location = loc.getURIString();
            if (encoding == null) {
                parser = new Parser(location);
            } else {
                Page page = null;
                page = new Page((InputStream)new BufferedInputStream(loc.openInputStream(), 1024), encoding);
                Lexer lexer = new Lexer(page);
                parser = new Parser(lexer);
            }
            HTMLElementImpl doc = null;
            doc = new HTMLElementImpl(true);
            NodeIterator it = parser.elements();
            while (it.hasMoreNodes()) {
                Node node = it.nextNode();
                doc.addChild(this.convert(node));
            }
            if (encoding == null) {
                encoding = parser.getLexer().getPage().getEncoding();
            }
            doc.setEncoding(encoding);
            template = new HTMLTemplateImpl(loc, encoding, doc);
        }
        catch (ParserException ex) {
            throw new TemplateParsingException("\u30d1\u30fc\u30b9\u4e2d\u306e\u4f8b\u5916", ex);
        }
        return template;
    }

    private HTMLNode convert(Node node) {
        if (node instanceof TagNode) {
            HTMLElementImpl tag = this.createHTMLElement((TagNode)node);
            NodeList children = node.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    HTMLNode converted = this.convert(children.elementAt(i));
                    if (converted == null || this.setEndTag(tag, converted)) continue;
                    tag.addChild(converted);
                }
            }
            return tag;
        }
        if (node instanceof RemarkNode) {
            String text = ((RemarkNode)node).getText();
            try {
                return new HTMLRemarkImpl(text);
            }
            catch (RemarkTextException ex) {
                try {
                    return new HTMLRemarkImpl(StringUtil.replace(text, "--", ""));
                }
                catch (RemarkTextException ex1) {
                    log.warn((Object)"", (Throwable)ex1);
                    return new HTMLTextImpl("");
                }
            }
        }
        if (node instanceof TextNode) {
            return new HTMLTextImpl(((TextNode)node).getText());
        }
        return null;
    }

    private HTMLElementImpl createHTMLElement(TagNode node) {
        Enumeration attrEnum = node.getAttributesEx().elements();
        Attribute tagNameAttr = (Attribute)attrEnum.nextElement();
        String tagName = tagNameAttr != null ? StringUtil.replace(tagNameAttr.getName(), "/", "") : node.getTagName();
        boolean startTag = !node.isEndTag();
        boolean endTag = node instanceof CompositeTag || node.isEndTag();
        HTMLElementImpl element = new HTMLElementImpl(tagName, startTag, endTag, false);
        while (attrEnum.hasMoreElements()) {
            HTMLValuedAttribute hva;
            HTMLNodeImpl ha;
            Attribute a = (Attribute)attrEnum.nextElement();
            String attrName = a.getName();
            String attrValue = a.getValue();
            if (a.isWhitespace()) {
                ha = new HTMLWhitespaceAttribute(a.getRawValue());
            } else if (a.isStandAlone()) {
                hva = new HTMLValuedAttribute(a.getName(), null);
                ha = hva;
                hva.setQuote(Character.toString(a.getQuote()));
            } else {
                hva = new HTMLValuedAttribute(a.getName(), a.getValue());
                hva.setQuote(Character.toString(a.getQuote()));
                if (a.isEmpty()) {
                    hva.setValue(null);
                }
                ha = hva;
            }
            element.addAttribute((HTMLAttribute)((Object)ha), false);
        }
        if (tagName.equalsIgnoreCase("!DOCTYPE")) {
            element.assemble();
        }
        return element;
    }

    private boolean setEndTag(HTMLElementImpl parent, HTMLNode tag) {
        if (tag instanceof HTMLElement && !((HTMLElementImpl)tag).hasStartTag()) {
            HTMLElement endTag = (HTMLElement)tag;
            String tagName = endTag.getTagName();
            try {
                HTMLElementImpl last = (HTMLElementImpl)parent.getLastTag(tagName);
                if (last.hasStartTag() && !last.hasEndTag()) {
                    HTMLNodeImpl next = last.next;
                    if (next != null) {
                        TemplateUtil.moveAll(next, last);
                    }
                    last.setEndTag(true);
                    return true;
                }
            }
            catch (NodeNotFoundException ex) {
                // empty catch block
            }
        }
        return false;
    }
}

