/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.FeatRuntimeException;
import feat2.StringUtil;
import feat2.template.HTMLNode;
import feat2.template.HTMLRemark;
import feat2.template.NodeNotFoundException;
import feat2.template.RemarkTextException;
import feat2.template.impl.DOMCommentImpl;
import feat2.template.impl.HTMLNodeImpl;

public class HTMLRemarkImpl
extends HTMLNodeImpl
implements HTMLRemark {
    private String text;

    HTMLRemarkImpl() {
        this.setDomNode(new DOMCommentImpl(this));
    }

    HTMLRemarkImpl(String str) throws RemarkTextException {
        this();
        if (str != null) {
            if (str.indexOf("--") > -1) {
                throw new RemarkTextException();
            }
            this.text = str;
        }
    }

    public void setText(String str) throws RemarkTextException {
        if (str != null) {
            if (str.indexOf("--") > -1) {
                throw new RemarkTextException();
            }
            this.text = str;
        } else {
            this.text = null;
        }
    }

    public String getText() {
        return this.text;
    }

    public void addText(String str) throws RemarkTextException {
        if (str != null) {
            if (str.indexOf("--") > -1) {
                throw new RemarkTextException();
            }
            this.text = this.text + str;
        }
    }

    public String toString() {
        if (this.text != null) {
            return StringUtil.unescapeHTMLText(this.text);
        }
        return "";
    }

    public String getValue() {
        return this.getText();
    }

    public HTMLNode copy(boolean deep) {
        try {
            return new HTMLRemarkImpl(this.text);
        }
        catch (RemarkTextException ex) {
            throw new FeatRuntimeException(ex);
        }
    }

    public StringBuffer toHTML(StringBuffer buf) {
        if (this.text != null) {
            String t;
            try {
                t = StringUtil.correctJapaneseChars(this.text, this.getDocument().getEncoding());
            }
            catch (NodeNotFoundException ex) {
                t = this.text;
            }
            buf.append("<!--").append(t).append("-->");
        }
        return buf;
    }

    public int getNodeType() {
        return 8;
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public void setFirstChild(HTMLNode child) {
    }
}

