/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.StringUtil;
import feat2.template.HTMLNode;
import feat2.template.HTMLText;
import feat2.template.NodeNotFoundException;
import feat2.template.impl.DOMTextImpl;
import feat2.template.impl.HTMLNodeImpl;

public class HTMLTextImpl
extends HTMLNodeImpl
implements HTMLText {
    private String text;

    HTMLTextImpl() {
        this(null);
    }

    public HTMLTextImpl(String rawText) {
        this.setRawText(rawText);
        this.setDomNode(new DOMTextImpl(this));
    }

    public void setText(String text) {
        if (text != null) {
            this.setRawText(StringUtil.escapeHTMLText(text));
        } else {
            this.setRawText(null);
        }
    }

    public void setRawText(String str) {
        this.text = str;
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        return StringUtil.unescapeHTMLText(this.text);
    }

    public void addText(String text) {
        this.addRawText(text == null ? null : StringUtil.escapeHTMLText(text));
    }

    public void addRawText(String str) {
        if (str != null) {
            this.text = this.text == null ? str : this.text + str;
        }
    }

    public String toString() {
        if (this.text != null) {
            return StringUtil.unescapeHTMLText(this.text);
        }
        return "";
    }

    public String getValue() {
        return this.getText();
    }

    public HTMLNode copy(boolean deep) {
        HTMLTextImpl ret = new HTMLTextImpl();
        ret.setRawText(this.text);
        return ret;
    }

    public StringBuffer toHTML(StringBuffer buf) {
        if (this.text != null) {
            String t;
            try {
                t = StringUtil.correctJapaneseChars(this.text, this.getDocument().getEncoding());
            }
            catch (NodeNotFoundException ex) {
                t = this.text;
            }
            buf.append(t);
        }
        return buf;
    }

    public int getNodeType() {
        return 3;
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public void setFirstChild(HTMLNode child) {
    }
}

