/*
 * Decompiled with CFR 0.152.
 */
package feat2.validation;

import feat2.validation.SingleValueValidator;
import feat2.validation.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;

public class LengthValidator
implements SingleValueValidator {
    private Integer max;
    private Integer min;

    public boolean validate(String value) {
        if (ValidatorUtil.isBlankOrNull(value)) {
            return true;
        }
        if (this.min != null && value.length() < this.min) {
            return false;
        }
        return this.max == null || value.length() <= this.max;
    }

    public String getDefaultMessageId() {
        if (this.max == null) {
            return "error.validation.minlength";
        }
        if (this.min == null) {
            return "error.validation.maxlength";
        }
        return "error.validation.length";
    }

    public Map getKeyrowds() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.min != null) {
            ret.put("min", this.min.toString());
        }
        if (this.max != null) {
            ret.put("max", this.max.toString());
        }
        return ret;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }
}

