/*
 * Decompiled with CFR 0.152.
 */
package feat2.validation;

import feat2.validation.SingleValueValidator;
import feat2.validation.ValidatorUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class NumberRangeValidator
implements SingleValueValidator {
    private BigDecimal max;
    private BigDecimal min;

    public boolean validate(String value) {
        BigDecimal source;
        if (ValidatorUtil.isBlankOrNull(value)) {
            return true;
        }
        try {
            source = new BigDecimal(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        if (this.min != null && source.compareTo(this.min) < 0) {
            return false;
        }
        return this.max == null || source.compareTo(this.max) <= 0;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public String getDefaultMessageId() {
        if (this.max == null) {
            return "error.validation.minrange";
        }
        if (this.min == null) {
            return "error.validation.maxrange";
        }
        return "error.validation.range";
    }

    public Map getKeyrowds() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.min != null) {
            ret.put("min", this.min.toString());
        }
        if (this.max != null) {
            ret.put("max", this.max.toString());
        }
        return ret;
    }
}

