/*
 * Decompiled with CFR 0.152.
 */
package feat2.validation;

import feat2.config.ConfigurationException;
import feat2.validation.SingleValueValidator;
import feat2.validation.ValidatorUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;

public class SimpleDateValidator
implements SingleValueValidator {
    private SimpleDateFormat format;

    public boolean validate(String value) {
        if (this.format == null) {
            throw new ConfigurationException("exception.validator.simpledate.format");
        }
        if (ValidatorUtil.isBlankOrNull(value)) {
            return true;
        }
        try {
            this.format.parse(value);
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    public void setPattern(String pattern) {
        this.format = new SimpleDateFormat(pattern);
        this.format.setLenient(true);
    }

    public String getDefaultMessageId() {
        return "error.validation.simpledate";
    }

    public Map getKeyrowds() {
        return null;
    }
}

