/*
 * Decompiled with CFR 0.152.
 */
package feat2.xmlcommand;

import feat2.xmlcommand.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ObjectHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog((Class)ObjectHandler.class);
    private HashMap[] objectStack = new HashMap[10];
    private int stackPointer = 0;
    private String currentProperty = null;
    private String featureName;
    private String commandName;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        log.debug((Object)("startElement:" + qName));
        if (qName.equals("command")) {
            this.commandName = attributes.getValue("commandname");
            this.featureName = attributes.getValue("featurename");
        }
        if (qName.equals("object") && this.objectStack.length > this.stackPointer) {
            HashMap obj = new HashMap();
            if (this.getCurrentObject() != null && attributes.getValue("name") != null) {
                this.getCurrentObject().put(attributes.getValue("value"), obj);
            }
            this.objectStack[this.stackPointer++] = obj;
        }
        if (qName.equals("property") && attributes.getValue("name") != null) {
            String isNull = attributes.getValue("isNull");
            this.currentProperty = isNull != null && isNull.equals("true") ? null : attributes.getValue("name");
        }
    }

    private HashMap getCurrentObject() {
        if (this.stackPointer > 0) {
            return this.objectStack[this.stackPointer - 1];
        }
        return null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        log.debug((Object)("property:" + this.currentProperty + "=" + value));
        try {
            Utils.setPropertyString(this.getCurrentObject(), this.currentProperty, value);
        }
        catch (InvocationTargetException ex) {
            throw new SAXException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SAXException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new SAXException(ex);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        log.debug((Object)("emdElement:" + qName));
        if (this.stackPointer > 0 && qName.equals("object")) {
            --this.stackPointer;
        }
    }

    public Map getObject() {
        return this.objectStack[0];
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getFeatureName() {
        return this.featureName;
    }
}

