/*
 * Decompiled with CFR 0.152.
 */
package feat2.xmlcommand;

import feat2.impl.XMLWriter;
import feat2.xmlcommand.ClientException;
import feat2.xmlcommand.ObjectHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLCommandProcessor {
    private Log log = LogFactory.getLog((Class)XMLCommandProcessor.class);
    private String requestObjectAttributeName = "feat2_xmlcommand_request";

    public String[] process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            try {
                Object is = req.getInputStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
                int size = 0;
                byte[] buf = new byte[8192];
                while ((size = is.read(buf)) > 0) {
                    os.write(buf, 0, size);
                }
                os.close();
                is.close();
                byte[] requestXML = os.toByteArray();
                this.log.debug((Object)("-- request --\n" + new String(requestXML, "UTF-8")));
                is = new ByteArrayInputStream(requestXML);
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                ObjectHandler handler = new ObjectHandler();
                parser.parse((InputStream)is, (DefaultHandler)handler);
                Map o = handler.getObject();
                req.setAttribute(this.requestObjectAttributeName, (Object)o);
                String[] ret = new String[]{handler.getFeatureName(), handler.getCommandName()};
                return ret;
            }
            catch (SAXException ex) {
                ex.printStackTrace();
                throw new ClientException(ex.getMessage(), "fatal");
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
                throw new ClientException(ex.getMessage(), "fatal");
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw new ClientException(ex.getMessage(), "fatal");
            }
        }
        catch (ClientException ex) {
            XMLWriter w = new XMLWriter();
            if (ex.getClientMessage() != null) {
                w.setError(ex.getErrorCode(), ex.getClientMessage());
            } else {
                w.setError(ex.getErrorCode());
            }
            String ret = w.toString();
            this.log.debug((Object)("-- response --\n" + ret));
            resp.getOutputStream().write(ret.getBytes("UTF-8"));
            return new String[2];
        }
    }
}

