/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.image.ConnectionStream;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.image.ImageReader;
import org.mobylet.core.util.HttpUtils;
import org.mobylet.core.util.PathUtils;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlUtils;

public class MobyletImageReader
implements ImageReader {
    protected File imageBaseUri;
    protected boolean isInitializedUri = false;

    @Override
    public File getImageBase() {
        File localBaseDir;
        if (this.isInitializedUri) {
            return this.imageBaseUri;
        }
        ImageConfig config = SingletonUtils.get(ImageConfig.class);
        String localBaseDirPath = config.getLocalBaseDirPath();
        if (StringUtils.isNotEmpty(localBaseDirPath) && (localBaseDir = new File(localBaseDirPath)).exists() && localBaseDir.isDirectory() && localBaseDir.canRead()) {
            this.imageBaseUri = localBaseDir;
        }
        this.isInitializedUri = true;
        return this.getImageBase();
    }

    @Override
    public ConnectionStream getStream(String path) {
        InputStream imageStream = null;
        if (PathUtils.isNetworkPath(path)) {
            HttpURLConnection connection = HttpUtils.getHttpUrlConnection(path);
            try {
                imageStream = connection.getInputStream();
            }
            catch (IOException e) {
                throw new MobyletRuntimeException("\u30b9\u30c8\u30ea\u30fc\u30e0\u3092\u30aa\u30fc\u30d7\u30f3\u3067\u304d\u307e\u305b\u3093 path = " + path, e);
            }
            return new ConnectionStream(connection, imageStream);
        }
        imageStream = ResourceUtils.getResourceFileOrInputStream(path);
        return new ConnectionStream(null, imageStream);
    }

    @Override
    public File getFile(String path) {
        if (this.getImageBase() == null) {
            return null;
        }
        return new File(this.getImageBase().getAbsolutePath() + File.separator + path);
    }

    @Override
    public String constructPath(String path) {
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        if (PathUtils.isNetworkPath(path)) {
            return path;
        }
        File imageBase = this.getImageBase();
        if (imageBase == null) {
            String currentUrl = UrlUtils.getCurrentUrl();
            int index = -1;
            index = currentUrl.lastIndexOf(47);
            currentUrl = index > 0 ? currentUrl.substring(0, index + 1) : currentUrl + "/";
            return currentUrl + path;
        }
        return imageBase.getAbsolutePath() + File.separator + path;
    }
}

