/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image.impl;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.image.ImageClipRectangle;
import org.mobylet.core.image.ImageCodec;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.image.ImageScaler;
import org.mobylet.core.image.ScaleType;
import org.mobylet.core.util.ImageUtils;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.SingletonUtils;

public class MobyletImageScaler
implements ImageScaler {
    @Override
    public void scale(InputStream imgStream, OutputStream outImage, ImageCodec imageCodec, Integer newWidth, ScaleType scaleType) {
        try {
            BufferedImage img = ImageIO.read(imgStream);
            if (newWidth == null) {
                ImageConfig config = SingletonUtils.get(ImageConfig.class);
                String defWidth = null;
                defWidth = config.getDefaultScaleImageWidth();
                newWidth = defWidth != null ? Integer.valueOf(Integer.parseInt(defWidth)) : Integer.valueOf(img.getWidth());
            }
            ImageClipRectangle rectangle = this.getClipRectangle(img.getWidth(), img.getHeight(), newWidth, scaleType);
            int scaledWidth = rectangle.getWidth();
            int scaledHeight = rectangle.getHeight();
            if (scaleType == ScaleType.CLIPSQUARE) {
                scaledWidth = newWidth;
                scaledHeight = newWidth;
            }
            BufferedImage outImg = null;
            outImg = img.getColorModel() instanceof IndexColorModel ? new BufferedImage(scaledWidth, scaledHeight, img.getType(), (IndexColorModel)img.getColorModel()) : (img.getType() == 0 ? new BufferedImage(scaledWidth, scaledHeight, 7) : new BufferedImage(scaledWidth, scaledHeight, img.getType()));
            if (outImg.getColorModel().hasAlpha() && outImg.getColorModel() instanceof IndexColorModel) {
                int transparentPixel = ((IndexColorModel)outImg.getColorModel()).getTransparentPixel();
                for (int i = 0; i < outImg.getWidth(); ++i) {
                    for (int j = 0; j < outImg.getHeight(); ++j) {
                        outImg.setRGB(i, j, transparentPixel);
                    }
                }
            }
            if (scaleType == ScaleType.CLIPSQUARE) {
                boolean isLongWidth = img.getWidth() > img.getHeight();
                int clipWidth = isLongWidth ? img.getHeight() : img.getWidth();
                img = img.getSubimage(isLongWidth ? (img.getWidth() - clipWidth) / 2 : 0, isLongWidth ? 0 : (img.getHeight() - clipWidth) / 2, clipWidth, clipWidth);
            }
            outImg.getGraphics().drawImage(img.getScaledInstance(scaledWidth, scaledHeight, 16), 0, 0, scaledWidth, scaledHeight, null);
            boolean result = ImageIO.write((RenderedImage)outImg, imageCodec.name(), outImage);
            if (!result) {
                throw new MobyletRuntimeException("\u753b\u50cf\u306e\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557", null);
            }
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("\u753b\u50cf\u5909\u63db\u4e2d\u306bIO\u4f8b\u5916\u304c\u767a\u751f", e);
        }
        finally {
            InputStreamUtils.closeQuietly(imgStream);
        }
    }

    @Override
    public ImageClipRectangle getClipRectangle(Integer width, Integer height, Integer newWidth, ScaleType scaleType) {
        return ImageUtils.getClipRectangle(width, height, newWidth, scaleType);
    }
}

