/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.pdf.PDF2XHTML;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFParser
implements Parser {
    public static final String PASSWORD = "org.apache.tika.parser.pdf.password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, Map<String, Object> context) throws IOException, SAXException, TikaException {
        PDDocument pdfDocument = PDDocument.load((InputStream)stream);
        try {
            if (pdfDocument.isEncrypted() && !pdfDocument.getCurrentAccessPermission().canExtractContent()) {
                try {
                    String password = metadata.get(PASSWORD);
                    if (password == null) {
                        password = "";
                    }
                    pdfDocument.decrypt(password);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            metadata.set("Content-Type", "application/pdf");
            this.extractMetadata(pdfDocument, metadata);
            PDF2XHTML.process(pdfDocument, handler, metadata);
        }
        finally {
            pdfDocument.close();
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        Map<String, Object> context = Collections.emptyMap();
        this.parse(stream, handler, metadata, context);
    }

    private void extractMetadata(PDDocument document, Metadata metadata) throws TikaException {
        PDDocumentInformation info = document.getDocumentInformation();
        this.addMetadata(metadata, "title", info.getTitle());
        this.addMetadata(metadata, "Author", info.getAuthor());
        this.addMetadata(metadata, "creator", info.getCreator());
        this.addMetadata(metadata, "Keywords", info.getKeywords());
        this.addMetadata(metadata, "producer", info.getProducer());
        this.addMetadata(metadata, "subject", info.getSubject());
        this.addMetadata(metadata, "trapped", info.getTrapped());
        try {
            this.addMetadata(metadata, "created", info.getCreationDate());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Calendar modified = info.getModificationDate();
            this.addMetadata(metadata, "Last-Modified", modified);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }

    private void addMetadata(Metadata metadata, String name, Calendar value) {
        if (value != null) {
            metadata.set(name, value.getTime().toString());
        }
    }
}

