/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.cbean.coption.SimpleStringOption;
import org.seasar.dbflute.cbean.coption.parts.local.JapaneseOptionPartsAgent;
import org.seasar.dbflute.cbean.sqlclause.WhereClauseArranger;
import org.seasar.dbflute.dbway.ExtensionOperand;
import org.seasar.dbflute.resource.ResourceContext;

public class LikeSearchOption
extends SimpleStringOption {
    protected static final String LIKE_PREFIX = "prefix";
    protected static final String LIKE_SUFFIX = "suffix";
    protected static final String LIKE_CONTAIN = "contain";
    protected String _like;
    protected String _escape;
    protected boolean _asOrSplit;

    public String getRearOption() {
        if (this._escape == null || this._escape.trim().length() == 0) {
            return "";
        }
        return " escape '" + this._escape + "'";
    }

    public LikeSearchOption likePrefix() {
        this._like = LIKE_PREFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeSuffix() {
        this._like = LIKE_SUFFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeContain() {
        this._like = LIKE_CONTAIN;
        this.doLikeAutoEscape();
        return this;
    }

    protected void doLikeAutoEscape() {
        this.escape();
    }

    public LikeSearchOption escape() {
        return this.escapeByPipeLine();
    }

    public LikeSearchOption escapeByPipeLine() {
        this._escape = "|";
        return this;
    }

    public LikeSearchOption escapeByAtMark() {
        this._escape = "@";
        return this;
    }

    public LikeSearchOption escapeBySlash() {
        this._escape = "/";
        return this;
    }

    public LikeSearchOption escapeByBackSlash() {
        this._escape = "\\";
        return this;
    }

    public LikeSearchOption notEscape() {
        this._escape = null;
        return this;
    }

    public LikeSearchOption splitBySpace() {
        return (LikeSearchOption)this.doSplitBySpace();
    }

    public LikeSearchOption splitBySpace(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitBySpace(splitLimitCount);
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte() {
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte();
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte(splitLimitCount);
    }

    public LikeSearchOption splitByPipeLine() {
        return (LikeSearchOption)this.doSplitByPipeLine();
    }

    public LikeSearchOption splitByPipeLine(int splitLimitCount) {
        return (LikeSearchOption)this.doSplitByPipeLine(splitLimitCount);
    }

    public LikeSearchOption asOrSplit() {
        this._asOrSplit = true;
        return this;
    }

    public boolean isAsOrSplit() {
        return this._asOrSplit;
    }

    public LikeSearchOption toUpperCase() {
        return (LikeSearchOption)this.doToUpperCase();
    }

    public LikeSearchOption toLowerCase() {
        return (LikeSearchOption)this.doToLowerCase();
    }

    public LikeSearchOption toSingleByteSpace() {
        return (LikeSearchOption)this.doToSingleByteSpace();
    }

    public LikeSearchOption toSingleByteAlphabetNumber() {
        return (LikeSearchOption)this.doToSingleByteAlphabetNumber();
    }

    public LikeSearchOption toSingleByteAlphabetNumberMark() {
        return (LikeSearchOption)this.doToSingleByteAlphabetNumberMark();
    }

    public JapaneseOptionPartsAgent localJapanese() {
        return this.doLocalJapanese();
    }

    public String generateRealValue(String value) {
        value = super.generateRealValue(value);
        if (this._escape != null && this._escape.trim().length() != 0) {
            String tmp = this.replace(value, this._escape, this._escape + this._escape);
            tmp = this.replace(tmp, "%", this._escape + "%");
            tmp = this.replace(tmp, "_", this._escape + "_");
            if (this.isCurrentDBDef(DBDef.Oracle)) {
                tmp = this.replace(tmp, "\uff05", this._escape + "\uff05");
                tmp = this.replace(tmp, "\uff3f", this._escape + "\uff3f");
            }
            value = tmp;
        }
        String wildCard = "%";
        if (this._like == null || this._like.trim().length() == 0) {
            return value;
        }
        if (this._like.equals(LIKE_PREFIX)) {
            return value + "%";
        }
        if (this._like.equals(LIKE_SUFFIX)) {
            return "%" + value;
        }
        if (this._like.equals(LIKE_CONTAIN)) {
            return "%" + value + "%";
        }
        String msg = "The like was wrong string: " + this._like;
        throw new IllegalStateException(msg);
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    protected SimpleStringOption newDeepCopyInstance() {
        return new LikeSearchOption();
    }

    public ExtensionOperand getExtensionOperand() {
        return null;
    }

    public WhereClauseArranger getWhereClauseArranger() {
        return null;
    }

    public String toString() {
        return "like=" + this._like + ", escape=" + this._escape + ", split=" + this.isSplit() + ", asOrSplit = " + this._asOrSplit;
    }
}

