/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.outsidesql;

import org.seasar.dbflute.jdbc.StatementConfig;

public class OutsideSqlOption {
    protected String _pagingRequestType = "non";
    protected boolean _dynamicBinding;
    protected StatementConfig _statementConfig;
    protected String _sourcePagingRequestType = "non";
    protected String _tableDbName;

    public void autoPaging() {
        this._pagingRequestType = "auto";
    }

    public void manualPaging() {
        this._pagingRequestType = "manual";
    }

    public void dynamicBinding() {
        this._dynamicBinding = true;
    }

    public String generateUniqueKey() {
        return "{" + this._pagingRequestType + "/" + this._dynamicBinding + "}";
    }

    public OutsideSqlOption copyOptionWithoutPaging() {
        OutsideSqlOption copyOption = new OutsideSqlOption();
        copyOption.setPagingSourceRequestType(this._pagingRequestType);
        if (this.isDynamicBinding()) {
            copyOption.dynamicBinding();
        }
        copyOption.setTableDbName(this._tableDbName);
        return copyOption;
    }

    public String toString() {
        return "{paging=" + this._pagingRequestType + ", dynamic=" + this._dynamicBinding + "}";
    }

    public boolean isAutoPaging() {
        return "auto".equals(this._pagingRequestType);
    }

    public boolean isManualPaging() {
        return "manual".equals(this._pagingRequestType);
    }

    public boolean isDynamicBinding() {
        return this._dynamicBinding;
    }

    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void setStatementConfig(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    protected void setPagingSourceRequestType(String sourcePagingRequestType) {
        this._sourcePagingRequestType = sourcePagingRequestType;
    }

    public boolean isSourcePagingRequestTypeAuto() {
        return "auto".equals(this._sourcePagingRequestType);
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }
}

