/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.util.Comparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestClassRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Enclosed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Enclosed.class)
public class SortableTest {
    private static Comparator<Description> forward() {
        return new Comparator<Description>(){

            @Override
            public int compare(Description o1, Description o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        };
    }

    private static Comparator<Description> backward() {
        return new Comparator<Description>(){

            @Override
            public int compare(Description o1, Description o2) {
                return o2.getDisplayName().compareTo(o1.getDisplayName());
            }
        };
    }

    public static class UnsortableRunnersAreHandledWithoutCrashing {
        @Test
        public void unsortablesAreHandledWithoutCrashing() {
            Request unsorted = Request.aClass(Unsortable.class).sortWith(SortableTest.forward());
            new JUnitCore().run(unsorted);
        }

        @Test
        public void testClassRunnerCanBeWrappedAroundUnsortable() throws InitializationError {
            TestClassRunner runner = new TestClassRunner(Unsortable.class, new UnsortableRunner(Unsortable.class));
            runner.sort(new Sorter(SortableTest.forward()));
        }

        @RunWith(value=UnsortableRunner.class)
        public static class Unsortable {
            @Test
            public void a() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class UnsortableRunner
        extends Runner {
            public UnsortableRunner(Class<?> klass) {
            }

            @Override
            public Description getDescription() {
                return Description.EMPTY;
            }

            @Override
            public void run(RunNotifier notifier) {
            }
        }
    }

    public static class TestClassRunnerIsSortable {
        private static String log = "";

        @Before
        public void resetLog() {
            log = "";
        }

        @Test
        public void sortingForwardWorksOnTestClassRunner() {
            Request forward = Request.aClass(SortMe.class).sortWith(SortableTest.forward());
            new JUnitCore().run(forward);
            Assert.assertEquals("abc", log);
        }

        @Test
        public void sortingBackwardWorksOnTestClassRunner() {
            Request backward = Request.aClass(SortMe.class).sortWith(SortableTest.backward());
            new JUnitCore().run(backward);
            Assert.assertEquals("cba", log);
        }

        @Test
        public void sortingForwardWorksOnSuite() {
            Request forward = Request.aClass(Enclosing.class).sortWith(SortableTest.forward());
            new JUnitCore().run(forward);
            Assert.assertEquals("AaAbAcBaBbBc", log);
        }

        @Test
        public void sortingBackwardWorksOnSuite() {
            Request backward = Request.aClass(Enclosing.class).sortWith(SortableTest.backward());
            new JUnitCore().run(backward);
            Assert.assertEquals("BcBbBaAcAbAa", log);
        }

        @RunWith(value=Enclosed.class)
        public static class Enclosing {

            public static class B {
                @Test
                public void a() {
                    log = log + "Ba";
                }

                @Test
                public void b() {
                    log = log + "Bb";
                }

                @Test
                public void c() {
                    log = log + "Bc";
                }
            }

            public static class A {
                @Test
                public void a() {
                    log = log + "Aa";
                }

                @Test
                public void b() {
                    log = log + "Ab";
                }

                @Test
                public void c() {
                    log = log + "Ac";
                }
            }
        }

        public static class SortMe {
            @Test
            public void a() {
                log = log + "a";
            }

            @Test
            public void b() {
                log = log + "b";
            }

            @Test
            public void c() {
                log = log + "c";
            }
        }
    }
}

