/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatTransformer
extends Transformer {
    private static final Logger LOG = Logger.getLogger(DateFormatTransformer.class.getName());
    public static final String DATE_TIME_FMT = "dateTimeFormat";

    @Override
    public Object transformRow(Map<String, Object> aRow, Context context) {
        for (Map<String, String> map : context.getAllEntityFields()) {
            String fmt = map.get(DATE_TIME_FMT);
            if (fmt == null) continue;
            String column = map.get("column");
            String srcCol = map.get("sourceColName");
            if (srcCol == null) {
                srcCol = column;
            }
            try {
                Object o = aRow.get(srcCol);
                if (o instanceof List) {
                    List inputs = (List)o;
                    ArrayList<Date> results = new ArrayList<Date>();
                    for (String input : inputs) {
                        results.add(this.process(input, fmt));
                    }
                    aRow.put(column, results);
                    continue;
                }
                String value = (String)o;
                aRow.put(column, this.process(value, fmt));
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, "Could not parse a Date field ", e);
            }
        }
        return aRow;
    }

    private Date process(String value, String format) throws ParseException {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return new SimpleDateFormat(format).parse(value);
    }
}

