/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public abstract class SolrWriter {
    private static final Logger LOG = Logger.getLogger(SolrWriter.class.getName());
    static final String IMPORTER_PROPERTIES = "dataimport.properties";
    static final String LAST_INDEX_KEY = "last_index_time";
    private final UpdateRequestProcessor processor;
    private final String configDir;
    public static final int START_ENTITY = 1;
    public static final int END_ENTITY = 2;
    public static final int TRANSFORMED_ROW = 3;
    public static final int ENTITY_META = 4;
    public static final int PRE_TRANSFORMER_ROW = 5;
    public static final int START_DOC = 6;
    public static final int END_DOC = 7;
    public static final int ENTITY_OUT = 8;
    public static final int ROW_END = 9;
    public static final int TRANSFORMER_EXCEPTION = 10;
    public static final int ENTITY_EXCEPTION = 11;
    public static final int DISABLE_LOGGING = 12;
    public static final int ENABLE_LOGGING = 13;

    public SolrWriter(UpdateRequestProcessor processor, String confDir) {
        this.processor = processor;
        this.configDir = confDir;
    }

    public boolean upload(SolrInputDocument d) {
        try {
            AddUpdateCommand command = new AddUpdateCommand();
            command.solrDoc = d;
            command.allowDups = false;
            command.overwritePending = true;
            command.overwriteCommitted = true;
            this.processor.processAdd(command);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception while adding: " + d, e);
            return false;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error creating document : " + d, e);
            return false;
        }
        return true;
    }

    public void deleteDoc(Object id) {
        try {
            LOG.info("deleted from document to Solr: " + id);
            DeleteUpdateCommand delCmd = new DeleteUpdateCommand();
            delCmd.id = id.toString();
            delCmd.fromPending = true;
            delCmd.fromCommitted = true;
            this.processor.processDelete(delCmd);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception while deleteing: " + id, e);
        }
    }

    Date getStartTime() {
        Properties props = this.readIndexerProperties();
        String result = props.getProperty(LAST_INDEX_KEY);
        try {
            if (result != null) {
                return DataImporter.DATE_TIME_FORMAT.parse(result);
            }
        }
        catch (ParseException e) {
            throw new DataImportHandlerException(400, "Unable to read last indexed time from: dataimport.properties", e);
        }
        return null;
    }

    private void persistStartTime(Date date) {
        OutputStream propOutput = null;
        Properties props = this.readIndexerProperties();
        try {
            props.put(LAST_INDEX_KEY, DataImporter.DATE_TIME_FORMAT.format(date));
            String filePath = this.configDir;
            if (this.configDir != null && !this.configDir.endsWith(File.separator)) {
                filePath = filePath + File.separator;
            }
            filePath = filePath + IMPORTER_PROPERTIES;
            propOutput = new FileOutputStream(filePath);
            props.store(propOutput, null);
            LOG.info("Wrote last indexed time to dataimport.properties");
        }
        catch (FileNotFoundException e) {
            throw new DataImportHandlerException(500, "Unable to persist Index Start Time", e);
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Unable to persist Index Start Time", e);
        }
        finally {
            try {
                if (propOutput != null) {
                    propOutput.close();
                }
            }
            catch (IOException e) {
                propOutput = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readIndexerProperties() {
        Properties props = new Properties();
        InputStream propInput = null;
        try {
            propInput = new FileInputStream(this.configDir + IMPORTER_PROPERTIES);
            props.load(propInput);
            LOG.info("Read dataimport.properties");
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to read: dataimport.properties");
        }
        finally {
            try {
                if (propInput != null) {
                    propInput.close();
                }
            }
            catch (IOException e) {
                propInput = null;
            }
        }
        return props;
    }

    public void deleteByQuery(String query) {
        try {
            LOG.info("Deleting documents from Solr with query: " + query);
            DeleteUpdateCommand delCmd = new DeleteUpdateCommand();
            delCmd.query = query;
            delCmd.fromCommitted = true;
            delCmd.fromPending = true;
            this.processor.processDelete(delCmd);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception while deleting by query: " + query, e);
        }
    }

    public void commit(boolean optimize) {
        try {
            CommitUpdateCommand commit = new CommitUpdateCommand(optimize);
            this.processor.processCommit(commit);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception while solr commit.", e);
        }
    }

    public void doDeleteAll() {
        try {
            DeleteUpdateCommand deleteCommand = new DeleteUpdateCommand();
            deleteCommand.query = "*:*";
            deleteCommand.fromCommitted = true;
            deleteCommand.fromPending = true;
            this.processor.processDelete(deleteCommand);
        }
        catch (IOException e) {
            throw new DataImportHandlerException(500, "Exception in full dump while deleting all documents.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getResourceAsString(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] buf = new byte[1024];
        int sz = 0;
        try {
            do {
                sz = in.read(buf);
                baos.write(buf, 0, sz);
            } while (sz >= buf.length);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return new String(baos.toByteArray());
    }

    static String getDocCount() {
        if (DocBuilder.INSTANCE.get() != null) {
            return "" + (DocBuilder.INSTANCE.get().importStatistics.docCount.get() + 1);
        }
        return "";
    }

    public Date loadIndexStartTime() {
        return this.getStartTime();
    }

    public void persistIndexStartTime(Date date) {
        this.persistStartTime(date);
    }

    public abstract SolrDoc getSolrDocInstance();

    public abstract boolean upload(SolrDoc var1);

    public abstract void log(int var1, String var2, Object var3);

    public static interface SolrDoc {
        public void addField(String var1, Object var2, float var3);

        public Object getField(String var1);

        public void setDocumentBoost(float var1);
    }
}

