/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.core.SolrResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    public static final Logger log = Logger.getLogger(Config.class.getName());
    static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private final Document doc;
    private final String prefix;
    private final String name;
    private final SolrResourceLoader loader;

    @Deprecated
    public Config(String name, InputStream is, String prefix) throws ParserConfigurationException, IOException, SAXException {
        this(null, name, is, prefix);
    }

    public Config(SolrResourceLoader loader, String name) throws ParserConfigurationException, IOException, SAXException {
        this(loader, name, null, null);
    }

    public Config(SolrResourceLoader loader, String name, InputStream is, String prefix) throws ParserConfigurationException, IOException, SAXException {
        if (loader == null) {
            loader = new SolrResourceLoader(null);
        }
        this.loader = loader;
        this.name = name;
        this.prefix = prefix != null && !prefix.endsWith("/") ? prefix + '/' : prefix;
        InputStream lis = is;
        try {
            if (lis == null) {
                lis = loader.openConfig(name);
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.doc = builder.parse(lis);
            DOMUtil.substituteProperties((Node)this.doc, (Properties)loader.getCoreProperties());
        }
        catch (SolrException e) {
            SolrException.log((Logger)log, (String)("Error in " + name), (Throwable)e);
            throw e;
        }
        finally {
            if (lis != is) {
                lis.close();
            }
        }
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String getResourceName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Document getDocument() {
        return this.doc;
    }

    public XPath getXPath() {
        return xpathFactory.newXPath();
    }

    private String normalize(String path) {
        return this.prefix == null || path.startsWith("/") ? path : this.prefix + path;
    }

    public Object evaluate(String path, QName type) {
        XPath xpath = xpathFactory.newXPath();
        try {
            String xstr = this.normalize(path);
            Object o = xpath.evaluate(xstr, this.doc, type);
            return o;
        }
        catch (XPathExpressionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + path + " for " + this.name, (Throwable)e, false);
        }
    }

    public Node getNode(String path, boolean errIfMissing) {
        XPath xpath = xpathFactory.newXPath();
        Node nd = null;
        String xstr = this.normalize(path);
        try {
            nd = (Node)xpath.evaluate(xstr, this.doc, XPathConstants.NODE);
            if (nd == null) {
                if (errIfMissing) {
                    throw new RuntimeException(this.name + " missing " + path);
                }
                log.fine(this.name + " missing optional " + path);
                return null;
            }
            log.finest(this.name + ":" + path + "=" + nd);
            return nd;
        }
        catch (XPathExpressionException e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e, false);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, e, false);
        }
    }

    public String getVal(String path, boolean errIfMissing) {
        Node nd = this.getNode(path, errIfMissing);
        if (nd == null) {
            return null;
        }
        String txt = DOMUtil.getText((Node)nd);
        log.fine(this.name + ' ' + path + '=' + txt);
        return txt;
    }

    public String get(String path) {
        return this.getVal(path, true);
    }

    public String get(String path, String def) {
        String val = this.getVal(path, false);
        return val != null ? val : def;
    }

    public int getInt(String path) {
        return Integer.parseInt(this.getVal(path, true));
    }

    public int getInt(String path, int def) {
        String val = this.getVal(path, false);
        return val != null ? Integer.parseInt(val) : def;
    }

    public boolean getBool(String path) {
        return Boolean.parseBoolean(this.getVal(path, true));
    }

    public boolean getBool(String path, boolean def) {
        String val = this.getVal(path, false);
        return val != null ? Boolean.parseBoolean(val) : def;
    }

    public float getFloat(String path) {
        return Float.parseFloat(this.getVal(path, true));
    }

    public float getFloat(String path, float def) {
        String val = this.getVal(path, false);
        return val != null ? Float.parseFloat(val) : def;
    }

    public double getDouble(String path) {
        return Double.parseDouble(this.getVal(path, true));
    }

    public double getDouble(String path, double def) {
        String val = this.getVal(path, false);
        return val != null ? Double.parseDouble(val) : def;
    }

    @Deprecated
    public String getConfigDir() {
        return this.loader.getConfigDir();
    }

    @Deprecated
    public InputStream openResource(String resource) {
        return this.loader.openResource(resource);
    }

    @Deprecated
    public List<String> getLines(String resource) throws IOException {
        return this.loader.getLines(resource);
    }

    @Deprecated
    public Class findClass(String cname, String ... subpackages) {
        return this.loader.findClass(cname, subpackages);
    }

    @Deprecated
    public Object newInstance(String cname, String ... subpackages) {
        return this.loader.newInstance(cname, subpackages);
    }

    @Deprecated
    public String getInstanceDir() {
        return this.loader.getInstanceDir();
    }
}

