/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.request.TextResponseWriter;
import org.apache.solr.request.XMLWriter;
import org.apache.solr.schema.FieldProperties;
import org.apache.solr.schema.FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaField
extends FieldProperties {
    final String name;
    final FieldType type;
    final int properties;
    final String defaultValue;
    boolean required = false;

    public SchemaField(String name, FieldType type) {
        this(name, type, type.properties, null);
    }

    public SchemaField(SchemaField prototype, String name) {
        this(name, prototype.type, prototype.properties, prototype.defaultValue);
    }

    public SchemaField(String name, FieldType type, int properties, String defaultValue) {
        this.name = name;
        this.type = type;
        this.properties = properties;
        this.defaultValue = defaultValue;
        this.required = (properties & 0x1000) != 0;
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    int getProperties() {
        return this.properties;
    }

    public boolean indexed() {
        return (this.properties & 1) != 0;
    }

    public boolean stored() {
        return (this.properties & 4) != 0;
    }

    public boolean storeTermVector() {
        return (this.properties & 0x40) != 0;
    }

    public boolean storeTermPositions() {
        return (this.properties & 0x80) != 0;
    }

    public boolean storeTermOffsets() {
        return (this.properties & 0x100) != 0;
    }

    public boolean omitNorms() {
        return (this.properties & 0x20) != 0;
    }

    public boolean multiValued() {
        return (this.properties & 0x200) != 0;
    }

    public boolean sortMissingFirst() {
        return (this.properties & 0x400) != 0;
    }

    public boolean sortMissingLast() {
        return (this.properties & 0x800) != 0;
    }

    public boolean isCompressed() {
        return (this.properties & 0x10) != 0;
    }

    public boolean isRequired() {
        return this.required;
    }

    boolean isTokenized() {
        return (this.properties & 2) != 0;
    }

    boolean isBinary() {
        return (this.properties & 8) != 0;
    }

    public Field createField(String val, float boost) {
        return this.type.createField(this, val, boost);
    }

    public String toString() {
        return this.name + "{type=" + this.type.getTypeName() + (this.defaultValue == null ? "" : ",default=" + this.defaultValue) + ",properties=" + SchemaField.propertiesToString(this.properties) + (this.required ? ", required=true" : "") + "}";
    }

    public void write(XMLWriter writer, String name, Fieldable val) throws IOException {
        this.type.write(writer, name, val);
    }

    public void write(TextResponseWriter writer, String name, Fieldable val) throws IOException {
        this.type.write(writer, name, val);
    }

    public SortField getSortField(boolean top) {
        return this.type.getSortField(this, top);
    }

    static SchemaField create(String name, FieldType ft, Map<String, String> props) {
        int pp;
        int trueProps = SchemaField.parseProperties(props, true);
        int falseProps = SchemaField.parseProperties(props, false);
        int p = ft.properties;
        if (SchemaField.on(falseProps, 4)) {
            pp = 28;
            if (SchemaField.on(pp, trueProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting stored field options:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(falseProps, 1)) {
            pp = 3553;
            if (SchemaField.on(pp, trueProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting indexed field options:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(falseProps, 64)) {
            pp = 448;
            if (SchemaField.on(pp, trueProps)) {
                throw new RuntimeException("SchemaField: " + name + " conflicting termvector field options:" + props);
            }
            p &= ~pp;
        }
        if (SchemaField.on(trueProps, 1024)) {
            p &= 0xFFFFF7FF;
        }
        if (SchemaField.on(trueProps, 2048)) {
            p &= 0xFFFFFBFF;
        }
        p &= ~falseProps;
        p |= trueProps;
        String defaultValue = null;
        if (props.containsKey("default")) {
            defaultValue = props.get("default");
        }
        return new SchemaField(name, ft, p, defaultValue);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

