/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public class TermsFilter
extends Filter {
    Set terms = new TreeSet();

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        OpenBitSet result = new OpenBitSet((long)reader.maxDoc());
        TermDocs td = reader.termDocs();
        try {
            Iterator iter = this.terms.iterator();
            while (iter.hasNext()) {
                Term term = (Term)iter.next();
                td.seek(term);
                while (td.next()) {
                    result.set((long)td.doc());
                }
            }
        }
        finally {
            td.close();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        TermsFilter test = (TermsFilter)((Object)obj);
        return this.terms == test.terms || this.terms != null && ((Object)this.terms).equals(test.terms);
    }

    public int hashCode() {
        int hash = 9;
        Iterator iter = this.terms.iterator();
        while (iter.hasNext()) {
            Term term = (Term)iter.next();
            hash = 31 * hash + term.hashCode();
        }
        return hash;
    }
}

