/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.TextPosition;
import org.apache.pdfbox.util.operator.OperatorProcessor;

public class PDFStreamEngine {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$pdfbox$util$PDFStreamEngine == null ? (class$org$apache$pdfbox$util$PDFStreamEngine = PDFStreamEngine.class$("org.apache.pdfbox.util.PDFStreamEngine")) : class$org$apache$pdfbox$util$PDFStreamEngine));
    private Vector unsupportedOperators = new Vector();
    private static final byte[] SPACE_BYTES = new byte[]{32};
    private PDGraphicsState graphicsState = null;
    private Matrix textMatrix = null;
    private Matrix textLineMatrix = null;
    private Stack graphicsStack = new Stack();
    private Map operators = new HashMap();
    private Stack streamResourcesStack = new Stack();
    private PDPage page;
    private Map documentFontCache = new HashMap();
    private int validCharCnt;
    private int totalCharCnt;
    static /* synthetic */ Class class$org$apache$pdfbox$util$PDFStreamEngine;

    public PDFStreamEngine() {
        this.validCharCnt = 0;
        this.totalCharCnt = 0;
    }

    public PDFStreamEngine(Properties properties) throws IOException {
        if (properties == null) {
            throw new NullPointerException("properties cannot be null");
        }
        try {
            Iterator keys = ((Hashtable)properties).keySet().iterator();
            while (keys.hasNext()) {
                String operator = (String)keys.next();
                String operatorClass = properties.getProperty(operator);
                OperatorProcessor op = (OperatorProcessor)Class.forName(operatorClass).newInstance();
                this.registerOperatorProcessor(operator, op);
            }
        }
        catch (Exception e) {
            throw new WrappedIOException(e);
        }
        this.validCharCnt = 0;
        this.totalCharCnt = 0;
    }

    public void registerOperatorProcessor(String operator, OperatorProcessor op) {
        op.setContext(this);
        this.operators.put(operator, op);
    }

    public void resetEngine() {
        this.documentFontCache.clear();
        this.validCharCnt = 0;
        this.totalCharCnt = 0;
    }

    public void processStream(PDPage aPage, PDResources resources, COSStream cosStream) throws IOException {
        this.graphicsState = new PDGraphicsState();
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.graphicsStack.clear();
        this.streamResourcesStack.clear();
        this.processSubStream(aPage, resources, cosStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSubStream(PDPage aPage, PDResources resources, COSStream cosStream) throws IOException {
        this.page = aPage;
        if (resources != null) {
            StreamResources sr = new StreamResources();
            sr.fonts = resources.getFonts(this.documentFontCache);
            sr.colorSpaces = resources.getColorSpaces();
            sr.xobjects = resources.getXObjects();
            sr.graphicsStates = resources.getGraphicsStates();
            sr.resources = resources;
            this.streamResourcesStack.push(sr);
        }
        try {
            ArrayList<COSBase> arguments = new ArrayList<COSBase>();
            List tokens = cosStream.getStreamTokens();
            if (tokens != null) {
                Iterator iter = tokens.iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (next instanceof COSObject) {
                        arguments.add(((COSObject)next).getObject());
                    } else if (next instanceof PDFOperator) {
                        this.processOperator((PDFOperator)next, arguments);
                        arguments = new ArrayList();
                    } else {
                        arguments.add((COSBase)next);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("token: " + next));
                }
            }
        }
        finally {
            if (resources != null) {
                this.streamResourcesStack.pop();
            }
        }
    }

    protected void processTextPosition(TextPosition text) {
    }

    public void processEncodedText(byte[] string) throws IOException {
        float fontSizeText = this.graphicsState.getTextState().getFontSize();
        float horizontalScalingText = this.graphicsState.getTextState().getHorizontalScalingPercent() / 100.0f;
        float riseText = this.graphicsState.getTextState().getRise();
        float wordSpacingText = this.graphicsState.getTextState().getWordSpacing();
        float characterSpacingText = this.graphicsState.getTextState().getCharacterSpacing();
        PDFont font = this.graphicsState.getTextState().getFont();
        float glyphSpaceToTextSpaceFactor = 1.0f / font.getFontMatrix().getValue(0, 0);
        float spaceWidthText = font.getFontWidth(SPACE_BYTES, 0, 1) / glyphSpaceToTextSpaceFactor;
        if (spaceWidthText == 0.0f) {
            spaceWidthText = font.getAverageFontWidth() / glyphSpaceToTextSpaceFactor;
            spaceWidthText *= 0.8f;
        }
        Matrix initialMatrix = new Matrix();
        initialMatrix.setValue(0, 0, 1.0f);
        initialMatrix.setValue(0, 1, 0.0f);
        initialMatrix.setValue(0, 2, 0.0f);
        initialMatrix.setValue(1, 0, 0.0f);
        initialMatrix.setValue(1, 1, 1.0f);
        initialMatrix.setValue(1, 2, 0.0f);
        initialMatrix.setValue(2, 0, 0.0f);
        initialMatrix.setValue(2, 1, riseText);
        initialMatrix.setValue(2, 2, 1.0f);
        Matrix ctm = this.graphicsState.getCurrentTransformationMatrix();
        Matrix textMatrixStDisp = initialMatrix.multiply(this.textMatrix).multiply(ctm);
        float xScaleDisp = textMatrixStDisp.getXScale();
        float yScaleDisp = textMatrixStDisp.getYScale();
        float spaceWidthDisp = spaceWidthText * xScaleDisp * fontSizeText;
        float wordSpacingDisp = wordSpacingText * xScaleDisp * fontSizeText;
        float maxVerticalDisplacementText = 0.0f;
        float[] individualWidthsText = new float[2048];
        StringBuffer stringResult = new StringBuffer(string.length);
        int codeLength = 1;
        for (int i = 0; i < string.length; i += codeLength) {
            codeLength = 1;
            String c = font.encode(string, i, codeLength);
            if (c == null && i + 1 < string.length) {
                c = font.encode(string, i, ++codeLength);
            }
            float characterHorizontalDisplacementText = font.getFontWidth(string, i, codeLength) / glyphSpaceToTextSpaceFactor;
            maxVerticalDisplacementText = Math.max(maxVerticalDisplacementText, font.getFontHeight(string, i, codeLength) / glyphSpaceToTextSpaceFactor);
            float spacingText = characterSpacingText;
            if (string[i] == 32 && c != null && c.equals(" ")) {
                spacingText += wordSpacingText;
            }
            float xPosBeforeText = initialMatrix.multiply(this.textMatrix).multiply(ctm).getXPosition();
            float adjustment = 0.0f;
            float tx = ((characterHorizontalDisplacementText - adjustment / glyphSpaceToTextSpaceFactor) * fontSizeText + spacingText) * horizontalScalingText;
            float ty = 0.0f;
            Matrix td = new Matrix();
            td.setValue(2, 0, tx);
            td.setValue(2, 1, ty);
            this.textMatrix = td.multiply(this.textMatrix);
            float widthText = initialMatrix.multiply(this.textMatrix).multiply(ctm).getXPosition() - xPosBeforeText;
            if (c != null) {
                float widthOfEachCharacterForCode = widthText / (float)c.length();
                for (int j = 0; j < c.length(); ++j) {
                    if (stringResult.length() + j >= individualWidthsText.length) continue;
                    if (c.equals("-")) {
                        // empty if block
                    }
                    individualWidthsText[stringResult.length() + j] = widthOfEachCharacterForCode;
                }
                this.validCharCnt += c.length();
            } else {
                c = "?";
            }
            this.totalCharCnt += c.length();
            stringResult.append(c);
        }
        String resultingString = stringResult.toString();
        if (individualWidthsText.length != resultingString.length()) {
            float[] tmp = new float[resultingString.length()];
            System.arraycopy(individualWidthsText, 0, tmp, 0, Math.min(individualWidthsText.length, resultingString.length()));
            individualWidthsText = tmp;
            if (resultingString.equals("- ")) {
                // empty if block
            }
        }
        float totalVerticalDisplacementDisp = maxVerticalDisplacementText * fontSizeText * yScaleDisp;
        Matrix textMatrixEndDisp = initialMatrix.multiply(this.textMatrix).multiply(ctm);
        this.processTextPosition(new TextPosition(this.page, textMatrixStDisp, textMatrixEndDisp, totalVerticalDisplacementDisp, individualWidthsText, spaceWidthDisp, stringResult.toString(), font, fontSizeText, (int)(fontSizeText * this.textMatrix.getXScale()), wordSpacingDisp));
    }

    public void processOperator(String operation, List arguments) throws IOException {
        try {
            PDFOperator oper = PDFOperator.getOperator(operation);
            this.processOperator(oper, arguments);
        }
        catch (IOException e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        try {
            String operation = operator.getOperation();
            OperatorProcessor processor = (OperatorProcessor)this.operators.get(operation);
            if (processor != null) {
                processor.setContext(this);
                processor.process(operator, arguments);
            } else if (!this.unsupportedOperators.contains(operation)) {
                log.info((Object)("unsupported/disabled operation: " + operation));
                this.unsupportedOperators.add(operation);
            }
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    public Map getColorSpaces() {
        return ((StreamResources)this.streamResourcesStack.peek()).colorSpaces;
    }

    public Map getXObjects() {
        return ((StreamResources)this.streamResourcesStack.peek()).xobjects;
    }

    public void setColorSpaces(Map value) {
        ((StreamResources)this.streamResourcesStack.peek()).colorSpaces = value;
    }

    public Map getFonts() {
        return ((StreamResources)this.streamResourcesStack.peek()).fonts;
    }

    public void setFonts(Map value) {
        ((StreamResources)this.streamResourcesStack.peek()).fonts = value;
    }

    public Stack getGraphicsStack() {
        return this.graphicsStack;
    }

    public void setGraphicsStack(Stack value) {
        this.graphicsStack = value;
    }

    public PDGraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    public void setGraphicsState(PDGraphicsState value) {
        this.graphicsState = value;
    }

    public Map getGraphicsStates() {
        return ((StreamResources)this.streamResourcesStack.peek()).graphicsStates;
    }

    public void setGraphicsStates(Map value) {
        ((StreamResources)this.streamResourcesStack.peek()).graphicsStates = value;
    }

    public Matrix getTextLineMatrix() {
        return this.textLineMatrix;
    }

    public void setTextLineMatrix(Matrix value) {
        this.textLineMatrix = value;
    }

    public Matrix getTextMatrix() {
        return this.textMatrix;
    }

    public void setTextMatrix(Matrix value) {
        this.textMatrix = value;
    }

    public PDResources getResources() {
        return ((StreamResources)this.streamResourcesStack.peek()).resources;
    }

    public PDPage getCurrentPage() {
        return this.page;
    }

    public int getValidCharCnt() {
        return this.validCharCnt;
    }

    public int getTotalCharCnt() {
        return this.totalCharCnt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StreamResources {
        private Map fonts;
        private Map colorSpaces;
        private Map xobjects;
        private Map graphicsStates;
        private PDResources resources;

        private StreamResources() {
        }
    }
}

