/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator.pagedrawer;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

public class AppendRectangleToPath
extends OperatorProcessor {
    public void process(PDFOperator operator, List arguments) {
        PageDrawer drawer = (PageDrawer)this.context;
        COSNumber x = (COSNumber)arguments.get(0);
        COSNumber y = (COSNumber)arguments.get(1);
        COSNumber w = (COSNumber)arguments.get(2);
        COSNumber h = (COSNumber)arguments.get(3);
        double x1 = x.floatValue();
        double y1 = y.floatValue();
        double x2 = (double)w.floatValue() + x1;
        double y2 = (double)h.floatValue() + y1;
        Point2D.Double startCoords = drawer.transformedPoint(x1, y1);
        Point2D.Double endCoords = drawer.transformedPoint(x2, y2);
        double width = ((Point2D)endCoords).getX() - ((Point2D)startCoords).getX();
        double height = ((Point2D)endCoords).getY() - ((Point2D)startCoords).getY();
        double xStart = ((Point2D)startCoords).getX();
        double yStart = ((Point2D)startCoords).getY();
        if (width < 0.0) {
            xStart += width;
            width = -width;
        }
        if (height < 0.0) {
            yStart += height;
            height = -height;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(xStart, yStart, width, height);
        drawer.getLinePath().append(rect, false);
    }
}

