/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jempbox.xmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.jempbox.impl.XMLUtil;
import org.apache.jempbox.xmp.Thumbnail;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaBasicJobTicket;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaDynamicMedia;
import org.apache.jempbox.xmp.XMPSchemaIptc4xmpCore;
import org.apache.jempbox.xmp.XMPSchemaMediaManagement;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.jempbox.xmp.XMPSchemaPagedText;
import org.apache.jempbox.xmp.XMPSchemaPhotoshop;
import org.apache.jempbox.xmp.XMPSchemaRightsManagement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

public class XMPMetadata {
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String ENCODING_UTF16BE = "UTF-16BE";
    public static final String ENCODING_UTF16LE = "UTF-16LE";
    protected Document xmpDocument;
    protected String encoding = "UTF-8";
    protected Map nsMappings = new HashMap();
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaPDF;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaBasic;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaDublinCore;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaMediaManagement;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaRightsManagement;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaBasicJobTicket;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaDynamicMedia;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaPagedText;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaIptc4xmpCore;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchemaPhotoshop;
    static /* synthetic */ Class class$org$apache$jempbox$xmp$XMPSchema;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$java$lang$String;

    public XMPMetadata() throws IOException {
        this.xmpDocument = XMLUtil.newDocument();
        ProcessingInstruction beginXPacket = this.xmpDocument.createProcessingInstruction("xpacket", "begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"");
        this.xmpDocument.appendChild(beginXPacket);
        Element xmpMeta = this.xmpDocument.createElementNS("adobe:ns:meta/", "x:xmpmeta");
        xmpMeta.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "adobe:ns:meta/");
        this.xmpDocument.appendChild(xmpMeta);
        Element rdf = this.xmpDocument.createElement("rdf:RDF");
        rdf.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        xmpMeta.appendChild(rdf);
        ProcessingInstruction endXPacket = this.xmpDocument.createProcessingInstruction("xpacket", "end=\"w\"");
        this.xmpDocument.appendChild(endXPacket);
        this.init();
    }

    public XMPMetadata(Document doc) {
        this.xmpDocument = doc;
        this.init();
    }

    private void init() {
        this.nsMappings.put("http://ns.adobe.com/pdf/1.3/", class$org$apache$jempbox$xmp$XMPSchemaPDF == null ? (class$org$apache$jempbox$xmp$XMPSchemaPDF = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaPDF")) : class$org$apache$jempbox$xmp$XMPSchemaPDF);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/", class$org$apache$jempbox$xmp$XMPSchemaBasic == null ? (class$org$apache$jempbox$xmp$XMPSchemaBasic = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaBasic")) : class$org$apache$jempbox$xmp$XMPSchemaBasic);
        this.nsMappings.put("http://purl.org/dc/elements/1.1/", class$org$apache$jempbox$xmp$XMPSchemaDublinCore == null ? (class$org$apache$jempbox$xmp$XMPSchemaDublinCore = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaDublinCore")) : class$org$apache$jempbox$xmp$XMPSchemaDublinCore);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/mm/", class$org$apache$jempbox$xmp$XMPSchemaMediaManagement == null ? (class$org$apache$jempbox$xmp$XMPSchemaMediaManagement = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaMediaManagement")) : class$org$apache$jempbox$xmp$XMPSchemaMediaManagement);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/rights/", class$org$apache$jempbox$xmp$XMPSchemaRightsManagement == null ? (class$org$apache$jempbox$xmp$XMPSchemaRightsManagement = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaRightsManagement")) : class$org$apache$jempbox$xmp$XMPSchemaRightsManagement);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/bj/", class$org$apache$jempbox$xmp$XMPSchemaBasicJobTicket == null ? (class$org$apache$jempbox$xmp$XMPSchemaBasicJobTicket = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaBasicJobTicket")) : class$org$apache$jempbox$xmp$XMPSchemaBasicJobTicket);
        this.nsMappings.put("http://ns.adobe.com/xmp/1.0/DynamicMedia/", class$org$apache$jempbox$xmp$XMPSchemaDynamicMedia == null ? (class$org$apache$jempbox$xmp$XMPSchemaDynamicMedia = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaDynamicMedia")) : class$org$apache$jempbox$xmp$XMPSchemaDynamicMedia);
        this.nsMappings.put("http://ns.adobe.com/xap/1.0/t/pg/", class$org$apache$jempbox$xmp$XMPSchemaPagedText == null ? (class$org$apache$jempbox$xmp$XMPSchemaPagedText = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaPagedText")) : class$org$apache$jempbox$xmp$XMPSchemaPagedText);
        this.nsMappings.put("http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", class$org$apache$jempbox$xmp$XMPSchemaIptc4xmpCore == null ? (class$org$apache$jempbox$xmp$XMPSchemaIptc4xmpCore = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaIptc4xmpCore")) : class$org$apache$jempbox$xmp$XMPSchemaIptc4xmpCore);
        this.nsMappings.put("http://ns.adobe.com/photoshop/1.0/", class$org$apache$jempbox$xmp$XMPSchemaPhotoshop == null ? (class$org$apache$jempbox$xmp$XMPSchemaPhotoshop = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaPhotoshop")) : class$org$apache$jempbox$xmp$XMPSchemaPhotoshop);
    }

    public void addXMLNSMapping(String namespace, Class xmpSchema) {
        if (!(class$org$apache$jempbox$xmp$XMPSchema == null ? (class$org$apache$jempbox$xmp$XMPSchema = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchema")) : class$org$apache$jempbox$xmp$XMPSchema).isAssignableFrom(xmpSchema)) {
            throw new IllegalArgumentException("Only XMPSchemas can be mapped to.");
        }
        this.nsMappings.put(namespace, xmpSchema);
    }

    public XMPSchemaPDF getPDFSchema() throws IOException {
        return (XMPSchemaPDF)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaPDF == null ? (class$org$apache$jempbox$xmp$XMPSchemaPDF = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaPDF")) : class$org$apache$jempbox$xmp$XMPSchemaPDF);
    }

    public XMPSchemaBasic getBasicSchema() throws IOException {
        return (XMPSchemaBasic)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaBasic == null ? (class$org$apache$jempbox$xmp$XMPSchemaBasic = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaBasic")) : class$org$apache$jempbox$xmp$XMPSchemaBasic);
    }

    public XMPSchemaDublinCore getDublinCoreSchema() throws IOException {
        return (XMPSchemaDublinCore)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaDublinCore == null ? (class$org$apache$jempbox$xmp$XMPSchemaDublinCore = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaDublinCore")) : class$org$apache$jempbox$xmp$XMPSchemaDublinCore);
    }

    public XMPSchemaMediaManagement getMediaManagementSchema() throws IOException {
        return (XMPSchemaMediaManagement)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaMediaManagement == null ? (class$org$apache$jempbox$xmp$XMPSchemaMediaManagement = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaMediaManagement")) : class$org$apache$jempbox$xmp$XMPSchemaMediaManagement);
    }

    public XMPSchemaRightsManagement getRightsManagementSchema() throws IOException {
        return (XMPSchemaRightsManagement)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaRightsManagement == null ? (class$org$apache$jempbox$xmp$XMPSchemaRightsManagement = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaRightsManagement")) : class$org$apache$jempbox$xmp$XMPSchemaRightsManagement);
    }

    public XMPSchemaBasicJobTicket getBasicJobTicketSchema() throws IOException {
        return (XMPSchemaBasicJobTicket)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaBasicJobTicket == null ? (class$org$apache$jempbox$xmp$XMPSchemaBasicJobTicket = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaBasicJobTicket")) : class$org$apache$jempbox$xmp$XMPSchemaBasicJobTicket);
    }

    public XMPSchemaDynamicMedia getDynamicMediaSchema() throws IOException {
        return (XMPSchemaDynamicMedia)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaDynamicMedia == null ? (class$org$apache$jempbox$xmp$XMPSchemaDynamicMedia = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaDynamicMedia")) : class$org$apache$jempbox$xmp$XMPSchemaDynamicMedia);
    }

    public XMPSchemaPagedText getPagedTextSchema() throws IOException {
        return (XMPSchemaPagedText)this.getSchemaByClass(class$org$apache$jempbox$xmp$XMPSchemaPagedText == null ? (class$org$apache$jempbox$xmp$XMPSchemaPagedText = XMPMetadata.class$("org.apache.jempbox.xmp.XMPSchemaPagedText")) : class$org$apache$jempbox$xmp$XMPSchemaPagedText);
    }

    public XMPSchemaMediaManagement addMediaManagementSchema() {
        XMPSchemaMediaManagement schema = new XMPSchemaMediaManagement(this);
        return (XMPSchemaMediaManagement)this.basicAddSchema(schema);
    }

    public XMPSchemaRightsManagement addRightsManagementSchema() {
        XMPSchemaRightsManagement schema = new XMPSchemaRightsManagement(this);
        return (XMPSchemaRightsManagement)this.basicAddSchema(schema);
    }

    public XMPSchemaBasicJobTicket addBasicJobTicketSchema() {
        XMPSchemaBasicJobTicket schema = new XMPSchemaBasicJobTicket(this);
        return (XMPSchemaBasicJobTicket)this.basicAddSchema(schema);
    }

    public XMPSchemaDynamicMedia addDynamicMediaSchema() {
        XMPSchemaDynamicMedia schema = new XMPSchemaDynamicMedia(this);
        return (XMPSchemaDynamicMedia)this.basicAddSchema(schema);
    }

    public XMPSchemaPagedText addPagedTextSchema() {
        XMPSchemaPagedText schema = new XMPSchemaPagedText(this);
        return (XMPSchemaPagedText)this.basicAddSchema(schema);
    }

    public void addSchema(XMPSchema schema) {
        Element rdf = this.getRDFElement();
        rdf.appendChild(schema.getElement());
    }

    public void save(String file) throws Exception {
        XMLUtil.save(this.xmpDocument, file, this.encoding);
    }

    public void save(OutputStream outStream) throws TransformerException {
        XMLUtil.save((Node)this.xmpDocument, outStream, this.encoding);
    }

    public byte[] asByteArray() throws Exception {
        return XMLUtil.asByteArray(this.xmpDocument, this.encoding);
    }

    public Document getXMPDocument() {
        return this.xmpDocument;
    }

    protected XMPSchema basicAddSchema(XMPSchema schema) {
        Element rdf = this.getRDFElement();
        rdf.appendChild(schema.getElement());
        return schema;
    }

    public XMPSchemaPDF addPDFSchema() {
        XMPSchemaPDF schema = new XMPSchemaPDF(this);
        return (XMPSchemaPDF)this.basicAddSchema(schema);
    }

    public XMPSchemaDublinCore addDublinCoreSchema() {
        XMPSchemaDublinCore schema = new XMPSchemaDublinCore(this);
        return (XMPSchemaDublinCore)this.basicAddSchema(schema);
    }

    public XMPSchemaBasic addBasicSchema() {
        XMPSchemaBasic schema = new XMPSchemaBasic(this);
        return (XMPSchemaBasic)this.basicAddSchema(schema);
    }

    public XMPSchemaIptc4xmpCore addIptc4xmpCoreSchema() {
        XMPSchemaIptc4xmpCore schema = new XMPSchemaIptc4xmpCore(this);
        return (XMPSchemaIptc4xmpCore)this.basicAddSchema(schema);
    }

    public XMPSchemaPhotoshop addPhotoshopSchema() {
        XMPSchemaPhotoshop schema = new XMPSchemaPhotoshop(this);
        return (XMPSchemaPhotoshop)this.basicAddSchema(schema);
    }

    public void setEncoding(String xmlEncoding) {
        this.encoding = xmlEncoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private Element getRDFElement() {
        Element rdf = null;
        NodeList nodes = this.xmpDocument.getElementsByTagName("rdf:RDF");
        if (nodes.getLength() > 0) {
            rdf = (Element)nodes.item(0);
        }
        return rdf;
    }

    public static XMPMetadata load(String file) throws IOException {
        return new XMPMetadata(XMLUtil.parse(file));
    }

    public static XMPMetadata load(InputSource is) throws IOException {
        return new XMPMetadata(XMLUtil.parse(is));
    }

    public static XMPMetadata load(InputStream is) throws IOException {
        return new XMPMetadata(XMLUtil.parse(is));
    }

    public static void main(String[] args) throws Exception {
        XMPMetadata metadata = new XMPMetadata();
        XMPSchemaPDF pdf = metadata.addPDFSchema();
        pdf.setAbout("uuid:b8659d3a-369e-11d9-b951-000393c97fd8");
        pdf.setKeywords("ben,bob,pdf");
        pdf.setPDFVersion("1.3");
        pdf.setProducer("Acrobat Distiller 6.0.1 for Macintosh");
        XMPSchemaDublinCore dc = metadata.addDublinCoreSchema();
        dc.addContributor("Ben Litchfield");
        dc.addContributor("Solar Eclipse");
        dc.addContributor("Some Other Guy");
        XMPSchemaBasic basic = metadata.addBasicSchema();
        Thumbnail t = new Thumbnail(metadata);
        t.setFormat("JPEG");
        t.setImage("IMAGE_DATA");
        t.setHeight(new Integer(100));
        t.setWidth(new Integer(200));
        basic.setThumbnail(t);
        basic.setBaseURL("http://www.pdfbox.org/");
        List schemas = metadata.getSchemas();
        System.out.println("schemas=" + schemas);
        metadata.save("test.xmp");
    }

    public List getSchemas() throws IOException {
        NodeList schemaList = this.xmpDocument.getElementsByTagName("rdf:Description");
        ArrayList<Object> retval = new ArrayList<Object>(schemaList.getLength());
        for (int i = 0; i < schemaList.getLength(); ++i) {
            Element schema = (Element)schemaList.item(i);
            boolean found = false;
            NamedNodeMap attributes = schema.getAttributes();
            for (int j = 0; j < attributes.getLength() && !found; ++j) {
                Node attribute = attributes.item(j);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (!name.startsWith("xmlns:") || !this.nsMappings.containsKey(value)) continue;
                Class schemaClass = (Class)this.nsMappings.get(value);
                try {
                    Constructor ctor = schemaClass.getConstructor(class$org$w3c$dom$Element == null ? XMPMetadata.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element, class$java$lang$String == null ? XMPMetadata.class$("java.lang.String") : class$java$lang$String);
                    retval.add(ctor.newInstance(schema, name.substring(6)));
                    found = true;
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Error: Class " + schemaClass.getName() + " must have a constructor with the signature of " + schemaClass.getName() + "( org.w3c.dom.Element, java.lang.String )");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            if (found) continue;
            retval.add(new XMPSchema(schema, null));
        }
        return retval;
    }

    public List getSchemasByNamespaceURI(String namespaceURI) throws IOException {
        List l = this.getSchemas();
        LinkedList<XMPSchema> result = new LinkedList<XMPSchema>();
        Class schemaClass = (Class)this.nsMappings.get(namespaceURI);
        if (schemaClass == null) {
            return result;
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            XMPSchema schema = (XMPSchema)i.next();
            if (!schemaClass.isAssignableFrom(schema.getClass())) continue;
            result.add(schema);
        }
        return result;
    }

    public boolean hasUnknownSchema() throws IOException {
        NodeList schemaList = this.xmpDocument.getElementsByTagName("rdf:Description");
        for (int i = 0; i < schemaList.getLength(); ++i) {
            Element schema = (Element)schemaList.item(i);
            NamedNodeMap attributes = schema.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (!name.startsWith("xmlns:") || this.nsMappings.containsKey(value) || value.equals("http://ns.adobe.com/xap/1.0/sType/ResourceEvent#")) continue;
                return true;
            }
        }
        return false;
    }

    public XMPSchema getSchemaByClass(Class targetSchema) throws IOException {
        Iterator iter = this.getSchemas().iterator();
        while (iter.hasNext()) {
            XMPSchema element = (XMPSchema)iter.next();
            if (!element.getClass().getName().equals(targetSchema.getName())) continue;
            return element;
        }
        return null;
    }

    public void merge(XMPMetadata metadata) throws IOException {
        List schemas2 = metadata.getSchemas();
        Iterator iterator = schemas2.iterator();
        while (iterator.hasNext()) {
            XMPSchema schema2 = (XMPSchema)iterator.next();
            XMPSchema schema1 = this.getSchemaByClass(schema2.getClass());
            if (schema1 == null) {
                Element rdf = this.getRDFElement();
                rdf.appendChild(this.xmpDocument.importNode(schema2.getElement(), true));
                continue;
            }
            schema1.merge(schema2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

