/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.delegate;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.delegate.AsyncResult;
import org.seasar.chronos.core.delegate.MethodCallback;
import org.seasar.chronos.core.exception.ExecutionRuntimeException;
import org.seasar.chronos.core.executor.ExecutorServiceFactory;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

public class MethodInvoker {
    private static final long serialVersionUID = -3755599989232609874L;
    private static Logger log = Logger.getLogger(MethodInvoker.class);
    private static final String CALLBACK_SUFFIX = "Callback";
    private final CopyOnWriteArrayList<AsyncResult> resultList = CollectionsUtil.newCopyOnWriteArrayList();
    private final Class<?> targetClass;
    private final Object target;
    private final BeanDesc beanDesc;
    private final ExecutorService executorService;
    private ExecutorServiceFactory executorServiceFactory;
    private ExecutorService callbackExecutorService;
    private boolean initialized;

    public MethodInvoker(ExecutorService executorService, ComponentDef componentDef) {
        this.executorService = executorService;
        this.target = componentDef.getComponent();
        this.targetClass = componentDef.getComponentClass();
        this.beanDesc = BeanDescFactory.getBeanDesc(this.targetClass);
    }

    public MethodInvoker(ExecutorService executorService, Object target, BeanDesc beanDesc) {
        this.executorService = executorService;
        this.beanDesc = beanDesc;
        this.target = target;
        this.targetClass = this.beanDesc.getBeanClass();
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            this.callbackExecutorService = this.executorServiceFactory.create(ThreadPoolType.SINGLE, null);
            this.initialized = true;
        }
    }

    public boolean awaitInvokes(long time, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(time, unit);
    }

    public AsyncResult beginInvoke(String methodName) throws InterruptedException {
        return this.beginInvoke(methodName, null, null, null);
    }

    public AsyncResult beginInvoke(String methodName, MethodCallback methodCallback, Object state) throws InterruptedException {
        return this.beginInvoke(methodName, null, methodCallback, state);
    }

    public AsyncResult beginInvoke(String methodName, Object[] args) throws InterruptedException {
        return this.beginInvoke(methodName, args, null, null);
    }

    public AsyncResult beginInvoke(final String methodName, final Object[] args, final MethodCallback methodCallback, Object state) throws InterruptedException {
        this.initialize();
        final AsyncResult asyncResult = new AsyncResult();
        this.resultList.add(asyncResult);
        asyncResult.setState(state);
        Future<Object> future = this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object result = MethodInvoker.this.invoke(methodName, args);
                if (methodCallback != null) {
                    MethodInvoker.this.callbackExecutorService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            MethodInvoker.this.callbackHandler(methodName, methodCallback, asyncResult);
                            return null;
                        }
                    });
                }
                MethodInvoker.this.resultList.remove(asyncResult);
                return result;
            }
        });
        asyncResult.setFuture(future);
        return asyncResult;
    }

    private void callbackHandler(String methodName, MethodCallback methodCallback, AsyncResult asyncResult) throws Exception {
        try {
            String callbackMethodName = methodCallback.getMethodName();
            StringBuffer sb = new StringBuffer();
            if (callbackMethodName == null) {
                sb.append(methodName);
                sb.append(CALLBACK_SUFFIX);
            } else {
                sb.append(callbackMethodName);
            }
            Method mt = ReflectionUtil.getDeclaredMethod(methodCallback.getTargetClass(), (String)sb.toString(), (Class[])new Class[]{AsyncResult.class});
            mt.setAccessible(true);
            ReflectionUtil.invoke((Method)mt, (Object)methodCallback.getTarget(), (Object[])new Object[]{asyncResult});
        }
        catch (Exception ex) {
            log.log("ECHRONOS0001", null, (Throwable)ex);
            throw ex;
        }
    }

    public boolean cancelInvoke(AsyncResult asyncResult) {
        return this.cancelInvoke(asyncResult, true);
    }

    public boolean cancelInvoke(AsyncResult asyncResult, boolean shutdown) {
        return asyncResult.getFuture().cancel(shutdown);
    }

    public void cancelInvokes() {
        this.cancelInvokes(true);
    }

    public void cancelInvokes(boolean shutdown) {
        if (shutdown) {
            this.executorService.shutdownNow();
        } else {
            this.executorService.shutdown();
        }
    }

    public Object endInvoke(AsyncResult asyncResult) throws InterruptedException {
        try {
            return asyncResult.getFuture().get();
        }
        catch (ExecutionException e) {
            throw new ExecutionRuntimeException(e);
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Method getMethod(String methodName) {
        return this.beanDesc.getMethod(methodName);
    }

    public boolean hasMethod(String methodName) {
        return this.beanDesc.hasMethod(methodName);
    }

    public Object invoke(String methodName) {
        return this.invoke(methodName, null);
    }

    public Object invoke(String methodName, Object[] args) {
        Object result = this.beanDesc.invoke(this.target, methodName, args);
        return result;
    }

    public void waitInvokes() throws InterruptedException {
        for (AsyncResult ar : this.resultList) {
            this.endInvoke(ar);
        }
    }

    public void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }
}

