/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.emoji;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mobylet.core.Carrier;
import org.mobylet.core.emoji.Emoji;
import org.mobylet.core.util.StringUtils;

public class EmojiPool {
    protected Carrier carrier;
    protected int minEmoji = 65535;
    protected int maxEmoji = 0;
    protected Map<Character, Emoji> emojiMap;
    protected Map<String, Emoji> emojiNameMap;
    protected Emoji[] emojiArray;
    protected boolean isConstructed = false;

    public EmojiPool(Carrier carrier) {
        this.carrier = carrier;
        this.emojiMap = new HashMap<Character, Emoji>(512);
        this.emojiNameMap = new HashMap<String, Emoji>(512);
    }

    public void construct() {
        if (this.maxEmoji != 0 && this.minEmoji != 65535) {
            this.emojiArray = new Emoji[this.maxEmoji - this.minEmoji + 1];
            Set<Map.Entry<Character, Emoji>> entrySet = this.emojiMap.entrySet();
            for (Map.Entry<Character, Emoji> emojiEntry : entrySet) {
                this.emojiArray[emojiEntry.getKey().charValue() - this.minEmoji] = emojiEntry.getValue();
            }
        }
        this.isConstructed = true;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public Emoji putWithName(String name, char c) {
        Emoji e = this.getUnConstructed(c);
        if (e != null) {
            if (StringUtils.isEmpty(e.getName()) && StringUtils.isNotEmpty(name)) {
                e.setName(name);
                this.emojiNameMap.put(name, e);
            }
        } else {
            e = this.putWithName(name, this.put(c).getCodes()[0]);
        }
        return e;
    }

    public Emoji put(char c) {
        Emoji e = new Emoji(this.carrier, c);
        return this.put(e);
    }

    public Emoji put(Emoji e) {
        char[] c = e.getCodes();
        if (c == null || c.length != 1) {
            return null;
        }
        this.emojiMap.put(Character.valueOf(c[0]), e);
        if (c[0] < this.minEmoji) {
            this.minEmoji = c[0];
        }
        if (c[0] > this.maxEmoji) {
            this.maxEmoji = c[0];
        }
        this.isConstructed = false;
        return e;
    }

    public boolean isEmoji(char c) {
        if (!this.isConstructed) {
            this.construct();
        }
        return this.minEmoji <= c && c <= this.maxEmoji && this.emojiArray[c - this.minEmoji] != null;
    }

    public Emoji get(char c) {
        if (this.isEmoji(c)) {
            return this.emojiArray[c - this.minEmoji];
        }
        return null;
    }

    public Emoji get(String name) {
        return this.emojiNameMap.get(name);
    }

    public Emoji getUnConstructed(char c) {
        return this.emojiMap.get(Character.valueOf(c));
    }

    public char getMinEmoji() {
        return (char)this.minEmoji;
    }

    public char getMaxEmoji() {
        return (char)this.maxEmoji;
    }
}

