/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.session.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.config.MobyletSessionConfig;
import org.mobylet.core.config.enums.SecureGateway;
import org.mobylet.core.holder.SessionHolder;
import org.mobylet.core.session.InvokeType;
import org.mobylet.core.session.MobyletSessionManager;
import org.mobylet.core.util.SerializeUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class MobyletMultiSessionManager
implements MobyletSessionManager {
    protected MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
    protected MobyletSessionConfig sessionConfig = SingletonUtils.get(MobyletSessionConfig.class);
    protected SessionHolder holder = SingletonUtils.get(SessionHolder.class);

    @Override
    public void invoke(HttpServletRequest request, HttpServletResponse response) {
        MobyletSessionConfig.Parameters parametersKey = this.sessionConfig.getDistribution().getParameters();
        String key = request.getParameter(parametersKey.getSessionKey());
        String type = request.getParameter(parametersKey.getInvokeTypeKey());
        String paramObject = request.getParameter(parametersKey.getObjectDataKey());
        InvokeType invokeType = InvokeType.valueOf(type);
        if (invokeType != InvokeType.INVALIDATE && StringUtils.isEmpty(paramObject)) {
            this.doEmptyResponse(response);
            return;
        }
        if (invokeType == InvokeType.GET) {
            Object obj = this.holder.get(key, (Class)SerializeUtils.deserialize(paramObject));
            if (obj == null) {
                this.doEmptyResponse(response);
                return;
            }
            byte[] objBytes = SerializeUtils.serialize2Bytes(obj);
            response.setContentType("application/octet-stream");
            response.setContentLength(objBytes.length);
            try {
                response.getOutputStream().write(SerializeUtils.serialize2Bytes(obj));
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u30ec\u30b9\u30dd\u30f3\u30b9\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
        if (invokeType == InvokeType.SET) {
            this.holder.set(key, SerializeUtils.deserialize(paramObject));
            response.setContentType("application/octet-stream");
            response.setContentLength(2);
            try {
                response.getOutputStream().write("OK".getBytes());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u30ec\u30b9\u30dd\u30f3\u30b9\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
        if (invokeType == InvokeType.REMOVE) {
            Object obj = this.holder.remove(key, (Class)SerializeUtils.deserialize(paramObject));
            if (obj == null) {
                this.doEmptyResponse(response);
                return;
            }
            byte[] objBytes = SerializeUtils.serialize2Bytes(obj);
            response.setContentType("application/octet-stream");
            response.setContentLength(objBytes.length);
            try {
                response.getOutputStream().write(SerializeUtils.serialize2Bytes(obj));
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u30ec\u30b9\u30dd\u30f3\u30b9\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
        if (invokeType == InvokeType.INVALIDATE) {
            this.holder.invalidate(key);
            response.setContentType("application/octet-stream");
            response.setContentLength(2);
            try {
                response.getOutputStream().write("OK".getBytes());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new MobyletRuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u30ec\u30b9\u30dd\u30f3\u30b9\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
    }

    @Override
    public boolean isManaged(HttpServletRequest request) {
        if (this.config.getSecureGateway() == SecureGateway.NONE || this.config.getSecureGateway() == SecureGateway.SECURE_CARRIER || this.sessionConfig.getDistribution() != null && this.sessionConfig.getDistribution().getAllowIps() != null && this.sessionConfig.getDistribution().isAllowIp(request.getRemoteAddr())) {
            return request.getRequestURI().equals(SingletonUtils.get(MobyletSessionConfig.class).getDistribution().getPath());
        }
        return false;
    }

    protected void doEmptyResponse(HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setStatus(200);
        response.setContentLength(0);
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

