/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mobylet.core.MobyletRuntimeException;

public class InputStreamUtils {
    public static byte[] getAllBytes(InputStream inputStream) {
        if (inputStream == null) {
            return new byte[0];
        }
        try {
            return InputStreamUtils.getBytes(inputStream, inputStream.available());
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", e);
        }
    }

    public static byte[] getBytesUnClose(InputStream inputStream, int length) {
        if (inputStream == null) {
            return new byte[0];
        }
        byte[] data = null;
        try {
            data = length != 0 ? new byte[length] : new byte[inputStream.available()];
            inputStream.read(data);
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", e);
        }
        return data;
    }

    public static byte[] getBytesToNull(InputStream inputStream, int threshold) {
        if (inputStream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(threshold);
        try {
            int b = 0;
            for (int index = 0; (b = inputStream.read()) != -1 && index < threshold; ++index) {
                baos.write(b);
            }
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", e);
        }
        return baos.toByteArray();
    }

    public static byte[] getBytes(InputStream inputStream, int length) {
        if (inputStream == null) {
            return new byte[0];
        }
        byte[] data = null;
        try {
            data = length != 0 ? new byte[length] : new byte[inputStream.available()];
            inputStream.read(data);
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304b\u3089\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return data;
    }

    public static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

