/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.seasar.extension.httpsession.S2HttpServletRequestWrapper;
import org.seasar.extension.httpsession.S2HttpSession;
import org.seasar.extension.httpsession.SessionIdUtil;
import org.seasar.extension.httpsession.SessionState;
import org.seasar.extension.httpsession.SessionStateManager;

public class S2HttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private S2HttpServletRequestWrapper requestWrapper;
    private SessionStateManager sessionStateManager;

    public S2HttpServletResponseWrapper(HttpServletResponse response, S2HttpServletRequestWrapper requestWrapper, SessionStateManager sessionStateManager) {
        super(response);
        this.requestWrapper = requestWrapper;
        this.sessionStateManager = sessionStateManager;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        return SessionIdUtil.rewriteURL(url, (HttpServletRequest)this.requestWrapper);
    }

    public String encodeUrl(String url) {
        return super.encodeURL(url);
    }

    public String encodeURL(String url) {
        return SessionIdUtil.rewriteURL(url, (HttpServletRequest)this.requestWrapper);
    }

    public void flushBuffer() throws IOException {
        SessionState sessionState;
        S2HttpSession session = this.requestWrapper.getS2HttpSession();
        if (session != null && (sessionState = session.getSessionState()) != null) {
            this.sessionStateManager.updateState(session.getId(), sessionState);
        }
        super.flushBuffer();
    }
}

