/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.XmlRootExtractor;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class ZipContainerDetector
implements Detector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(4);
        try {
            if (input.read() != 80 || input.read() != 75 || input.read() != 3 || input.read() != 4) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
        }
        finally {
            input.reset();
        }
        if (!TikaInputStream.isTikaInputStream((InputStream)input)) {
            return MediaType.APPLICATION_ZIP;
        }
        try {
            File file = TikaInputStream.get((InputStream)input).getFile();
            ZipFile zip = new ZipFile(file);
            MediaType type = this.detectOpenDocument(zip);
            if (type == null) {
                type = this.detectOfficeOpenXML(zip, TikaInputStream.get((InputStream)input));
            }
            if (type == null) {
                type = this.detectIWork(zip);
            }
            if (type == null && zip.getEntry("META-INF/MANIFEST.MF") != null) {
                type = MediaType.application((String)"java-archive");
            }
            if (type == null) {
                type = MediaType.APPLICATION_ZIP;
            }
            return type;
        }
        catch (IOException e) {
            return MediaType.APPLICATION_ZIP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MediaType detectOpenDocument(ZipFile zip) {
        MediaType mediaType;
        ZipArchiveEntry mimetype = zip.getEntry("mimetype");
        if (mimetype == null) return null;
        InputStream stream = zip.getInputStream(mimetype);
        try {
            mediaType = MediaType.parse((String)IOUtils.toString((InputStream)stream, (String)"UTF-8"));
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        stream.close();
        return mediaType;
    }

    private MediaType detectOfficeOpenXML(ZipFile zip, TikaInputStream stream) {
        try {
            if (zip.getEntry("_rels/.rels") != null || zip.getEntry("[Content_Types].xml") != null) {
                OPCPackage pkg = OPCPackage.open((String)stream.getFile().getPath());
                stream.setOpenContainer((Object)pkg);
                PackageRelationshipCollection core = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
                if (core.size() != 1) {
                    return null;
                }
                PackagePart corePart = pkg.getPart(core.getRelationship(0));
                String coreType = corePart.getContentType();
                String docType = coreType.substring(0, coreType.lastIndexOf(46));
                if (docType.toLowerCase().endsWith("macroenabled")) {
                    docType = docType.toLowerCase() + ".12";
                }
                return MediaType.parse((String)docType);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }

    private MediaType detectIWork(ZipFile zip) {
        if (zip.getEntry("buildVersionHistory.plist") != null) {
            MediaType type = this.detectIWork(zip, "index.apxl");
            if (type == null) {
                type = this.detectIWork(zip, "index.xml");
            }
            if (type == null) {
                type = this.detectIWork(zip, "presentation.apxl");
            }
            if (type == null) {
                return MediaType.application((String)"vnd.apple.iwork");
            }
            return type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MediaType detectIWork(ZipFile zip, String name) {
        try {
            ZipArchiveEntry entry = zip.getEntry(name);
            if (entry == null) {
                return null;
            }
            InputStream stream = zip.getInputStream(entry);
            try {
                QName qname = new XmlRootExtractor().extractRootElement(stream);
                String uri = qname.getNamespaceURI();
                String local = qname.getLocalPart();
                if ("http://developer.apple.com/namespaces/ls".equals(uri) && "document".equals(local)) {
                    MediaType mediaType = MediaType.application((String)"vnd.apple.numbers");
                    return mediaType;
                }
                if ("http://developer.apple.com/namespaces/sl".equals(uri) && "document".equals(local)) {
                    MediaType mediaType = MediaType.application((String)"vnd.apple.pages");
                    return mediaType;
                }
                if ("http://developer.apple.com/namespaces/keynote2".equals(uri) && "presentation".equals(local)) {
                    MediaType mediaType = MediaType.application((String)"vnd.apple.keynote");
                    return mediaType;
                }
                MediaType mediaType = null;
                return mediaType;
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

