/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.html.HtmlMapper;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class HtmlHandler
extends TextContentHandler {
    private static final Set<String> URI_ATTRIBUTES = new HashSet<String>(){
        {
            this.add("src");
            this.add("href");
            this.add("longdesc");
            this.add("data");
            this.add("cite");
            this.add("codebase");
            this.add("classid");
        }
    };
    private final HtmlMapper mapper;
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private int bodyLevel = 0;
    private int discardLevel = 0;
    private int titleLevel = 0;
    private final StringBuilder title = new StringBuilder();
    private static final Pattern ICBM = Pattern.compile("\\s*(-?\\d+\\.\\d+)[,\\s]+(-?\\d+\\.\\d+)\\s*");

    private HtmlHandler(HtmlMapper mapper, XHTMLContentHandler xhtml, Metadata metadata) {
        super((ContentHandler)xhtml);
        String name;
        this.mapper = mapper;
        this.xhtml = xhtml;
        this.metadata = metadata;
        if (metadata.get("Content-Location") == null && (name = metadata.get("resourceName")) != null) {
            name = name.trim();
            try {
                new URL(name);
                metadata.set("Content-Location", name);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    public HtmlHandler(HtmlMapper mapper, ContentHandler handler, Metadata metadata) {
        this(mapper, new XHTMLContentHandler(handler, metadata), metadata);
    }

    public void startElement(String uri, String local, String name, Attributes atts) throws SAXException {
        String safe;
        if ("TITLE".equals(name) || this.titleLevel > 0) {
            ++this.titleLevel;
        }
        if ("BODY".equals(name) || "FRAMESET".equals(name) || this.bodyLevel > 0) {
            ++this.bodyLevel;
        }
        if (this.mapper.isDiscardElement(name) || this.discardLevel > 0) {
            ++this.discardLevel;
        }
        if (this.bodyLevel == 0 && this.discardLevel == 0) {
            if ("META".equals(name) && atts.getValue("content") != null) {
                if (atts.getValue("http-equiv") != null) {
                    this.addHtmlMetadata(atts.getValue("http-equiv"), atts.getValue("content"));
                } else if (atts.getValue("name") != null) {
                    this.addHtmlMetadata(atts.getValue("name"), atts.getValue("content"));
                }
            } else if ("BASE".equals(name) && atts.getValue("href") != null) {
                this.startElementWithSafeAttributes("base", atts);
                this.xhtml.endElement("base");
                this.metadata.set("Content-Location", this.resolve(atts.getValue("href")));
            } else if ("LINK".equals(name)) {
                this.startElementWithSafeAttributes("link", atts);
                this.xhtml.endElement("link");
            }
        }
        if (this.bodyLevel > 0 && this.discardLevel == 0 && (safe = this.mapper.mapSafeElement(name)) != null) {
            this.startElementWithSafeAttributes(safe, atts);
        }
        this.title.setLength(0);
    }

    private void addHtmlMetadata(String name, String value) {
        if (name != null && value != null) {
            if (name.equalsIgnoreCase("ICBM")) {
                Matcher m = ICBM.matcher(value);
                if (m.matches()) {
                    this.metadata.set("ICBM", m.group(1) + ", " + m.group(2));
                    this.metadata.set(Metadata.LATITUDE, m.group(1));
                    this.metadata.set(Metadata.LONGITUDE, m.group(2));
                } else {
                    this.metadata.set("ICBM", value);
                }
            } else if (name.equalsIgnoreCase("Content-Type")) {
                MediaType type = MediaType.parse((String)value);
                if (type != null) {
                    this.metadata.set("Content-Type", type.toString());
                } else {
                    this.metadata.set("Content-Type", value);
                }
            } else {
                this.metadata.set(name, value);
            }
        }
    }

    private void startElementWithSafeAttributes(String name, Attributes atts) throws SAXException {
        if (atts.getLength() == 0) {
            this.xhtml.startElement(name);
            return;
        }
        AttributesImpl newAttributes = new AttributesImpl(atts);
        for (int att = 0; att < newAttributes.getLength(); ++att) {
            String normAttrName = this.mapper.mapSafeAttribute(name, newAttributes.getLocalName(att));
            if (normAttrName == null) {
                newAttributes.removeAttribute(att);
                --att;
                continue;
            }
            newAttributes.setLocalName(att, normAttrName);
            if (!URI_ATTRIBUTES.contains(normAttrName)) continue;
            newAttributes.setValue(att, this.resolve(newAttributes.getValue(att)));
        }
        this.xhtml.startElement(name, newAttributes);
    }

    public void endElement(String uri, String local, String name) throws SAXException {
        if (this.bodyLevel > 0 && this.discardLevel == 0) {
            String safe = this.mapper.mapSafeElement(name);
            if (safe != null) {
                this.xhtml.endElement(safe);
            } else if (XHTMLContentHandler.ENDLINE.contains(name.toLowerCase(Locale.ENGLISH))) {
                this.xhtml.newline();
            }
        }
        if (this.titleLevel > 0) {
            --this.titleLevel;
            if (this.titleLevel == 0) {
                this.metadata.set("title", this.title.toString().trim());
            }
        }
        if (this.bodyLevel > 0) {
            --this.bodyLevel;
        }
        if (this.discardLevel > 0) {
            --this.discardLevel;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.titleLevel > 0 && this.bodyLevel == 0) {
            this.title.append(ch, start, length);
        }
        if (this.bodyLevel > 0 && this.discardLevel == 0) {
            super.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.bodyLevel > 0 && this.discardLevel == 0) {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    private String resolve(String url) {
        url = url.trim();
        if (this.metadata.get("Content-Location") == null) {
            return url;
        }
        String lower = url.toLowerCase(Locale.ENGLISH);
        if (lower.startsWith("urn:") || lower.startsWith("mailto:") || lower.startsWith("tel:") || lower.startsWith("data:") || lower.startsWith("javascript:") || lower.startsWith("about:")) {
            return url;
        }
        try {
            URL base = new URL(this.metadata.get("Content-Location").trim());
            String path = base.getPath();
            if (url.startsWith("?") && path.length() > 0 && !path.endsWith("/")) {
                return new URL(base.getProtocol(), base.getHost(), base.getPort(), base.getPath() + url).toExternalForm();
            }
            return new URL(base, url).toExternalForm();
        }
        catch (MalformedURLException e) {
            return url;
        }
    }
}

