/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSStreamException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerIntInfoGenerator;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private List _signerInfs = new ArrayList();
    private List _messageDigests = new ArrayList();
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, attributeTable, attributeTable2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, attributeTable, attributeTable2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(privateKey, CMSSignedDataStreamGenerator.getSignerIdentifier(x509Certificate), string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, attributeTable, attributeTable2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(privateKey, CMSSignedDataStreamGenerator.getSignerIdentifier(byArray), string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider, Provider provider2) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(privateKey, CMSSignedDataStreamGenerator.getSignerIdentifier(x509Certificate), string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider, Provider provider2) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(privateKey, CMSSignedDataStreamGenerator.getSignerIdentifier(byArray), string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider2);
    }

    private void doAddSigner(PrivateKey privateKey, SignerIdentifier signerIdentifier, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider, Provider provider2) throws NoSuchAlgorithmException, InvalidKeyException {
        String string3 = CMSSignedHelper.INSTANCE.getDigestAlgName(string2);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string3, provider2);
        SignerIntInfoGeneratorImpl signerIntInfoGeneratorImpl = new SignerIntInfoGeneratorImpl(privateKey, signerIdentifier, string2, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, this.rand);
        this._signerInfs.add(new DigestAndSignerInfoGeneratorHolder(signerIntInfoGeneratorImpl, messageDigest, string2));
        this._messageDigests.add(messageDigest);
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl);
    }

    public OutputStream open(OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl, outputStream2);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl) throws IOException {
        return this.open(outputStream, string, bl, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl) throws IOException {
        return this.open(aSN1ObjectIdentifier, outputStream, bl, null);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(new ASN1ObjectIdentifier(string), outputStream, bl, outputStream2);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        Object object2;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject((DEREncodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject((DEREncodable)this.calculateVersion(aSN1ObjectIdentifier));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object2 : this._signers) {
            aSN1EncodableVector.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object2).getDigestAlgorithmID()));
        }
        for (Object object2 : this._signerInfs) {
            aSN1EncodableVector.add((DEREncodable)((DigestAndSignerInfoGeneratorHolder)object2).getDigestAlgorithm());
        }
        for (Object object2 : this.signerGens) {
            aSN1EncodableVector.add((DEREncodable)((SignerInfoGenerator)object2).getDigestAlgorithm());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject((DEREncodable)aSN1ObjectIdentifier);
        object2 = bl ? CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream outputStream3 = CMSUtils.getSafeTeeOutputStream(outputStream2, (OutputStream)object2);
        OutputStream outputStream4 = CMSUtils.attachDigestsToOutputStream(this._messageDigests, outputStream3);
        OutputStream outputStream5 = CMSUtils.attachSignersToOutputStream(this.signerGens, outputStream4);
        return new CmsSignedDataOutputStream(outputStream5, aSN1ObjectIdentifier, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    void generate(OutputStream outputStream, String string, boolean bl, OutputStream outputStream2, CMSProcessable cMSProcessable) throws CMSException, IOException {
        OutputStream outputStream3 = this.open(outputStream, string, bl, outputStream2);
        if (cMSProcessable != null) {
            cMSProcessable.write(outputStream3);
        }
        outputStream3.close();
    }

    private DERInteger calculateVersion(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.certs != null) {
            for (Object e : this.certs) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new DERInteger(5);
        }
        if (this.crls != null) {
            for (Object e : this.crls) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new DERInteger(5);
        }
        if (bl4) {
            return new DERInteger(4);
        }
        if (bl3) {
            return new DERInteger(3);
        }
        if (this.checkForVersion3(this._signers)) {
            return new DERInteger(3);
        }
        if (!CMSObjectIdentifiers.data.equals((Object)aSN1ObjectIdentifier)) {
            return new DERInteger(3);
        }
        return new DERInteger(1);
    }

    private boolean checkForVersion3(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SignerInfo signerInfo = SignerInfo.getInstance((Object)((SignerInformation)iterator.next()).toSignerInfo());
            if (signerInfo.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, ASN1ObjectIdentifier aSN1ObjectIdentifier, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = aSN1ObjectIdentifier;
            this._sGen = bERSequenceGenerator;
            this._sigGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        @Override
        public void write(int n) throws IOException {
            this._out.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        @Override
        public void close() throws IOException {
            byte[] byArray;
            ASN1Set aSN1Set;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (DEREncodable)aSN1Set).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                aSN1Set = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (DEREncodable)aSN1Set).getEncoded());
            }
            aSN1Set = new ASN1EncodableVector();
            for (Object object : CMSSignedDataStreamGenerator.this._signerInfs) {
                byArray = ((DigestAndSignerInfoGeneratorHolder)object).digest.digest();
                CMSSignedDataStreamGenerator.this.digests.put(((DigestAndSignerInfoGeneratorHolder)object).digestOID, byArray.clone());
                AlgorithmIdentifier algorithmIdentifier = ((DigestAndSignerInfoGeneratorHolder)object).getDigestAlgorithm();
                aSN1Set.add((DEREncodable)((DigestAndSignerInfoGeneratorHolder)object).signerInf.generate((DERObjectIdentifier)this._contentOID, algorithmIdentifier, byArray));
            }
            for (Object object : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    aSN1Set.add((DEREncodable)((SignerInfoGenerator)object).generate(this._contentOID));
                    byArray = ((SignerInfoGenerator)object).getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(((SignerInfoGenerator)object).getDigestAlgorithm().getAlgorithm().getId(), byArray);
                }
                catch (CMSException cMSException) {
                    throw new CMSStreamException("exception generating signers: " + cMSException.getMessage(), cMSException);
                }
            }
            for (Object object : CMSSignedDataStreamGenerator.this._signers) {
                aSN1Set.add((DEREncodable)((SignerInformation)object).toSignerInfo());
            }
            this._sigGen.getRawOutputStream().write(new DERSet((ASN1EncodableVector)aSN1Set).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }

    private class DigestAndSignerInfoGeneratorHolder {
        SignerIntInfoGenerator signerInf;
        MessageDigest digest;
        String digestOID;

        DigestAndSignerInfoGeneratorHolder(SignerIntInfoGenerator signerIntInfoGenerator, MessageDigest messageDigest, String string) {
            this.signerInf = signerIntInfoGenerator;
            this.digest = messageDigest;
            this.digestOID = string;
        }

        AlgorithmIdentifier getDigestAlgorithm() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), (DEREncodable)DERNull.INSTANCE);
        }
    }

    private class SignerIntInfoGeneratorImpl
    implements SignerIntInfoGenerator {
        private final SignerIdentifier _signerIdentifier;
        private final String _encOID;
        private final CMSAttributeTableGenerator _sAttr;
        private final CMSAttributeTableGenerator _unsAttr;
        private final String _encName;
        private final Signature _sig;

        SignerIntInfoGeneratorImpl(PrivateKey privateKey, SignerIdentifier signerIdentifier, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidKeyException {
            this._signerIdentifier = signerIdentifier;
            this._encOID = string2;
            this._sAttr = cMSAttributeTableGenerator;
            this._unsAttr = cMSAttributeTableGenerator2;
            this._encName = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this._encOID);
            String string3 = CMSSignedHelper.INSTANCE.getDigestAlgName(string);
            String string4 = string3 + "with" + this._encName;
            if (this._sAttr != null) {
                this._sig = CMSSignedHelper.INSTANCE.getSignatureInstance(string4, provider);
            } else if (this._encName.equals("RSA")) {
                this._sig = CMSSignedHelper.INSTANCE.getSignatureInstance("RSA", provider);
            } else if (this._encName.equals("DSA")) {
                this._sig = CMSSignedHelper.INSTANCE.getSignatureInstance("NONEwithDSA", provider);
            } else {
                throw new NoSuchAlgorithmException("algorithm: " + this._encName + " not supported in base signatures.");
            }
            this._sig.initSign(privateKey, secureRandom);
        }

        @Override
        public SignerInfo generate(DERObjectIdentifier dERObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws CMSStreamException {
            try {
                Map<String, Object> map;
                AttributeTable attributeTable;
                Object object;
                byte[] byArray2 = byArray;
                ASN1Set aSN1Set = null;
                if (this._sAttr != null) {
                    object = CMSSignedDataStreamGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                    attributeTable = this._sAttr.getAttributes(Collections.unmodifiableMap(object));
                    if (dERObjectIdentifier == null && attributeTable != null && attributeTable.get((DERObjectIdentifier)CMSAttributes.contentType) != null) {
                        map = attributeTable.toHashtable();
                        ((Hashtable)map).remove(CMSAttributes.contentType);
                        attributeTable = new AttributeTable(map);
                    }
                    aSN1Set = CMSSignedDataStreamGenerator.this.getAttributeSet(attributeTable);
                    byArray2 = aSN1Set.getEncoded("DER");
                } else if (this._encName.equals("RSA")) {
                    object = new DigestInfo(algorithmIdentifier, byArray);
                    byArray2 = object.getEncoded("DER");
                }
                this._sig.update(byArray2);
                object = this._sig.sign();
                attributeTable = null;
                if (this._unsAttr != null) {
                    map = CMSSignedDataStreamGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                    map.put("encryptedDigest", object.clone());
                    AttributeTable attributeTable2 = this._unsAttr.getAttributes(Collections.unmodifiableMap(map));
                    attributeTable = CMSSignedDataStreamGenerator.this.getAttributeSet(attributeTable2);
                }
                map = CMSSignedDataStreamGenerator.this.getEncAlgorithmIdentifier(this._encOID, this._sig);
                return new SignerInfo(this._signerIdentifier, algorithmIdentifier, aSN1Set, map, (ASN1OctetString)new DEROctetString((byte[])object), (ASN1Set)attributeTable);
            }
            catch (IOException iOException) {
                throw new CMSStreamException("encoding error.", iOException);
            }
            catch (SignatureException signatureException) {
                throw new CMSStreamException("error creating signature.", signatureException);
            }
        }
    }
}

