/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.fork.MemoryURLConnection;

class MemoryURLStreamHandler
extends URLStreamHandler {
    private static final AtomicInteger counter = new AtomicInteger();
    private static final Map<URL, byte[]> URLs = new WeakHashMap<URL, byte[]>();

    MemoryURLStreamHandler() {
    }

    public static URL createURL(byte[] data) {
        try {
            int i = counter.incrementAndGet();
            URL url = new URL("tika-in-memory", "localhost", "/" + i);
            URLs.put(url, data);
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected URLConnection openConnection(URL u) throws IOException {
        byte[] data = URLs.get(u);
        if (data != null) {
            return new MemoryURLConnection(u, URLs.get(u));
        }
        throw new IOException("Unknown URL: " + u);
    }
}

