/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeType
implements Comparable<MimeType>,
Serializable {
    private static final long serialVersionUID = 4357830439860729201L;
    private final MediaType type;
    private String description = "";
    private final ArrayList<Magic> magics = new ArrayList();
    private final ArrayList<RootXML> rootXML = new ArrayList();
    private int minLength = 0;
    private String extension = "";

    public static boolean isValid(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is missing");
        }
        boolean slash = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch <= ' ' || ch >= '\u007f' || ch == '(' || ch == ')' || ch == '<' || ch == '>' || ch == '@' || ch == ',' || ch == ';' || ch == ':' || ch == '\\' || ch == '\"' || ch == '[' || ch == ']' || ch == '?' || ch == '=') {
                return false;
            }
            if (ch != '/') continue;
            if (slash || i == 0 || i + 1 == name.length()) {
                return false;
            }
            slash = true;
        }
        return slash;
    }

    MimeType(MediaType type) {
        if (type == null) {
            throw new IllegalArgumentException("Media type name is missing");
        }
        this.type = type;
    }

    public MediaType getType() {
        return this.type;
    }

    public String getName() {
        return this.type.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Description is missing");
        }
        this.description = description;
    }

    void addRootXML(String namespaceURI, String localName) {
        this.rootXML.add(new RootXML(this, namespaceURI, localName));
    }

    boolean matchesXML(String namespaceURI, String localName) {
        for (RootXML xml : this.rootXML) {
            if (!xml.matches(namespaceURI, localName)) continue;
            return true;
        }
        return false;
    }

    boolean hasRootXML() {
        return this.rootXML.size() > 0;
    }

    RootXML[] getRootXMLs() {
        return this.rootXML.toArray(new RootXML[this.rootXML.size()]);
    }

    Magic[] getMagics() {
        return this.magics.toArray(new Magic[this.magics.size()]);
    }

    void addMagic(Magic magic) {
        if (magic == null) {
            return;
        }
        this.magics.add(magic);
    }

    int getMinLength() {
        return this.minLength;
    }

    public boolean hasMagic() {
        return this.magics.size() > 0;
    }

    public boolean matchesMagic(byte[] data) {
        for (int i = 0; i < this.magics.size(); ++i) {
            Magic magic = this.magics.get(i);
            if (!magic.eval(data)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(byte[] data) {
        return this.matchesMagic(data);
    }

    @Override
    public int compareTo(MimeType mime) {
        return this.type.compareTo(mime.type);
    }

    public String toString() {
        return this.type.toString();
    }

    public String getExtension() {
        return this.extension;
    }

    void setExtension(String extension) {
        this.extension = extension;
    }

    class RootXML
    implements Serializable {
        private static final long serialVersionUID = 5140496601491000730L;
        private MimeType type = null;
        private String namespaceURI = null;
        private String localName = null;

        RootXML(MimeType type, String namespaceURI, String localName) {
            if (this.isEmpty(namespaceURI) && this.isEmpty(localName)) {
                throw new IllegalArgumentException("Both namespaceURI and localName cannot be empty");
            }
            this.type = type;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
        }

        boolean matches(String namespaceURI, String localName) {
            if (!this.isEmpty(this.namespaceURI) ? !this.namespaceURI.equals(namespaceURI) : !this.isEmpty(namespaceURI)) {
                return false;
            }
            return !(!this.isEmpty(this.localName) ? !this.localName.equals(localName) : !this.isEmpty(localName));
        }

        private boolean isEmpty(String str) {
            return str == null || str.equals("");
        }

        MimeType getType() {
            return this.type;
        }

        String getNameSpaceURI() {
            return this.namespaceURI;
        }

        String getLocalName() {
            return this.localName;
        }

        public String toString() {
            return this.type + ", " + this.namespaceURI + ", " + this.localName;
        }
    }
}

