/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

class TokenOrderingFilter
extends TokenFilter {
    private final int windowSize;
    private final LinkedList<Token> queue = new LinkedList();
    private boolean done = false;

    protected TokenOrderingFilter(TokenStream input, int windowSize) {
        super(input);
        this.windowSize = windowSize;
    }

    public Token next() throws IOException {
        while (!this.done && this.queue.size() < this.windowSize) {
            Token newTok = this.input.next();
            if (newTok == null) {
                this.done = true;
                break;
            }
            ListIterator<Token> iter = this.queue.listIterator(this.queue.size());
            while (iter.hasPrevious()) {
                if (newTok.startOffset() < iter.previous().startOffset()) continue;
                iter.next();
                break;
            }
            iter.add(newTok);
        }
        return this.queue.isEmpty() ? null : this.queue.removeFirst();
    }
}

