/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.db.allcommon;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.extension.dbcp.ConnectionWrapper;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.robot.db.allcommon.DBCurrent;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.QLog;
import org.seasar.robot.dbflute.XLog;
import org.seasar.robot.dbflute.bhv.core.supplement.SequenceCacheKeyGenerator;
import org.seasar.robot.dbflute.bhv.outsidesql.factory.OutsideSqlExecutorFactory;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseCreator;
import org.seasar.robot.dbflute.dbmeta.name.SqlNameFilter;
import org.seasar.robot.dbflute.exception.IllegalDBFluteConfigAccessException;
import org.seasar.robot.dbflute.jdbc.DataSourceHandler;
import org.seasar.robot.dbflute.jdbc.NotClosingConnectionWrapper;
import org.seasar.robot.dbflute.jdbc.PhysicalConnectionDigger;
import org.seasar.robot.dbflute.jdbc.SQLExceptionDigger;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.s2dao.valuetype.TnValueTypes;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.OracleAgent;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.OracleArrayType;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.OracleDateType;
import org.seasar.robot.dbflute.s2dao.valuetype.plugin.OracleStructType;
import org.seasar.robot.dbflute.util.DfReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBFluteConfig {
    private static final Log _log = LogFactory.getLog(DBFluteConfig.class);
    private static final String DEFAULT_OUTSIDE_SQL_PACKAGE = null;
    private static final boolean DEFAULT_USE_SQL_LOG_REGISTRY = false;
    private static final DBFluteConfig _instance = new DBFluteConfig();
    protected boolean _disableSelectIndex;
    protected boolean _emptyStringQueryAllowed;
    protected boolean _emptyStringParameterAllowed;
    protected boolean _invalidQueryChecked;
    protected boolean _queryLogLevelInfo;
    protected boolean _executeStatusLogLevelInfo;
    protected String _logDateFormat;
    protected String _logTimestampFormat;
    protected StatementConfig _defaultStatementConfig;
    protected DataSourceHandler _dataSourceHandler;
    protected PhysicalConnectionDigger _physicalConnectionDigger;
    protected SQLExceptionDigger _sqlExceptionDigger;
    protected String _outsideSqlPackage = DEFAULT_OUTSIDE_SQL_PACKAGE;
    protected boolean _useSqlLogRegistry = false;
    protected SequenceCacheKeyGenerator _sequenceCacheKeyGenerator;
    protected SqlClauseCreator _sqlClauseCreator;
    protected SqlNameFilter _tableSqlNameFilter;
    protected OutsideSqlExecutorFactory _outsideSqlExecutorFactory;
    protected boolean _internalDebug;
    protected boolean _locked = true;

    private DBFluteConfig() {
        this._physicalConnectionDigger = new ImplementedPhysicalConnectionDigger();
        this._sqlExceptionDigger = new ImplementedSQLExceptionDigger();
        if (this.isCurrentDBDef(DBDef.Oracle)) {
            this._logDateFormat = "timestamp $df:{yyyy-MM-dd HH:mm:ss}";
            this._logTimestampFormat = "timestamp $df:{yyyy-MM-dd HH:mm:ss.SSS}";
        }
    }

    public static DBFluteConfig getInstance() {
        return _instance;
    }

    public boolean isDisableSelectIndex() {
        return this._disableSelectIndex;
    }

    public void setDisableSelectIndex(boolean disableSelectIndex) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting disableSelectIndex: " + disableSelectIndex));
        }
        this._disableSelectIndex = disableSelectIndex;
    }

    public boolean isEmptyStringQueryAllowed() {
        return this._emptyStringQueryAllowed;
    }

    public void setEmptyStringQueryAllowed(boolean emptyStringQueryAllowed) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting emptyStringQueryAllowed: " + emptyStringQueryAllowed));
        }
        this._emptyStringQueryAllowed = emptyStringQueryAllowed;
    }

    public boolean isEmptyStringParameterAllowed() {
        return this._emptyStringParameterAllowed;
    }

    public void setEmptyStringParameterAllowed(boolean emptyStringParameterAllowed) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting emptyStringParameterAllowed: " + emptyStringParameterAllowed));
        }
        this._emptyStringParameterAllowed = emptyStringParameterAllowed;
    }

    public boolean isInvalidQueryChecked() {
        return this._invalidQueryChecked;
    }

    public void setInvalidQueryChecked(boolean invalidQueryChecked) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting invalidQueryChecked: " + invalidQueryChecked));
        }
        this._invalidQueryChecked = invalidQueryChecked;
    }

    public void setQueryLogLevelInfo(boolean queryLogLevelInfo) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting queryLogLevelInfo: " + queryLogLevelInfo));
        }
        QLog.unlock();
        QLog.setQueryLogLevelInfo((boolean)queryLogLevelInfo);
        QLog.lock();
    }

    public void setExecuteStatusLogLevelInfo(boolean executeStatusLogLevelInfo) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting executeStatusLogLevelInfo: " + executeStatusLogLevelInfo));
        }
        XLog.unlock();
        XLog.setExecuteStatusLogLevelInfo((boolean)executeStatusLogLevelInfo);
        XLog.lock();
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogDateFormat(String logDateFormat) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting logDateFormat: " + logDateFormat));
        }
        this._logDateFormat = logDateFormat;
    }

    public String getLogTimestampFormat() {
        return this._logTimestampFormat;
    }

    public void setLogTimestampFormat(String logTimestampFormat) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting logTimestampFormat: " + logTimestampFormat));
        }
        this._logTimestampFormat = logTimestampFormat;
    }

    public StatementConfig getDefaultStatementConfig() {
        return this._defaultStatementConfig;
    }

    public void setDefaultStatementConfig(StatementConfig defaultStatementConfig) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting defaultStatementConfig: " + defaultStatementConfig));
        }
        this._defaultStatementConfig = defaultStatementConfig;
    }

    public DataSourceHandler getDataSourceHandler() {
        return this._dataSourceHandler;
    }

    public void setDataSourceHandler(DataSourceHandler dataSourceHandler) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting dataSourceHandler: " + dataSourceHandler));
        }
        this._dataSourceHandler = dataSourceHandler;
    }

    public PhysicalConnectionDigger getPhysicalConnectionDigger() {
        return this._physicalConnectionDigger;
    }

    public void setPhysicalConnectionDigger(PhysicalConnectionDigger physicalConnectionDigger) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting physicalConnectionDigger: " + physicalConnectionDigger));
        }
        if (physicalConnectionDigger == null) {
            throw new IllegalArgumentException("The argument 'physicalConnectionDigger' should not be null.");
        }
        this._physicalConnectionDigger = physicalConnectionDigger;
    }

    public SQLExceptionDigger getSQLExceptionDigger() {
        return this._sqlExceptionDigger;
    }

    public void setSQLExceptionDigger(SQLExceptionDigger sqlExceptionDigger) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting sqlExceptionDigger: " + sqlExceptionDigger));
        }
        if (sqlExceptionDigger == null) {
            throw new IllegalArgumentException("The argument 'sqlExceptionDigger' should not be null.");
        }
        this._sqlExceptionDigger = sqlExceptionDigger;
    }

    public String getOutsideSqlPackage() {
        return this._outsideSqlPackage;
    }

    public void setOutsideSqlPackage(String outsideSqlPackage) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting outsideSqlPackage: " + outsideSqlPackage));
        }
        this._outsideSqlPackage = outsideSqlPackage;
    }

    public boolean isUseSqlLogRegistry() {
        return this._useSqlLogRegistry;
    }

    public void setUseSqlLogRegistry(boolean useSqlLogRegistry) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting useSqlLogRegistry: " + useSqlLogRegistry));
        }
        this._useSqlLogRegistry = useSqlLogRegistry;
    }

    public SequenceCacheKeyGenerator getSequenceCacheKeyGenerator() {
        return this._sequenceCacheKeyGenerator;
    }

    public void setSequenceCacheKeyGenerator(SequenceCacheKeyGenerator sequenceCacheKeyGenerator) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting sequenceCacheKeyGenerator: " + sequenceCacheKeyGenerator));
        }
        this._sequenceCacheKeyGenerator = sequenceCacheKeyGenerator;
    }

    public SqlClauseCreator getSqlClauseCreator() {
        return this._sqlClauseCreator;
    }

    public void setSqlClauseCreator(SqlClauseCreator sqlClauseCreator) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting sqlClauseCreator: " + sqlClauseCreator));
        }
        this._sqlClauseCreator = sqlClauseCreator;
    }

    public SqlNameFilter getTableSqlNameFilter() {
        return this._tableSqlNameFilter;
    }

    public void setTableSqlNameFilter(SqlNameFilter tableSqlNameFilter) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting tableSqlNameFilter: " + tableSqlNameFilter));
        }
        this._tableSqlNameFilter = tableSqlNameFilter;
    }

    public OutsideSqlExecutorFactory getOutsideSqlExecutorFactory() {
        return this._outsideSqlExecutorFactory;
    }

    public void setOutsideSqlExecutorFactory(OutsideSqlExecutorFactory outsideSqlExecutorFactory) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting outsideSqlExecutorFactory: " + outsideSqlExecutorFactory));
        }
        this._outsideSqlExecutorFactory = outsideSqlExecutorFactory;
    }

    public boolean isInternalDebug() {
        return this._internalDebug;
    }

    public void setInternalDebug(boolean internalDebug) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting internalDebug: " + internalDebug));
        }
        this._internalDebug = internalDebug;
    }

    public void registerBasicValueType(Class<?> keyType, ValueType valueType) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Registering basic valueType: " + keyType + " = " + valueType));
        }
        TnValueTypes.registerBasicValueType((DBDef)this.currentDBDef(), keyType, (ValueType)valueType);
    }

    public void removeBasicValueType(Class<?> keyType) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Removing basic valueType: " + keyType));
        }
        TnValueTypes.removeBasicValueType((DBDef)this.currentDBDef(), keyType);
    }

    public void registerPluginValueType(String keyName, ValueType valueType) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Registering plug-in valueType: " + keyName + " = " + valueType));
        }
        TnValueTypes.registerPluginValueType((DBDef)this.currentDBDef(), (String)keyName, (ValueType)valueType);
    }

    public void removePluginValueType(String keyName) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Removing plug-in valueType: keyName=" + keyName));
        }
        TnValueTypes.removePluginValueType((DBDef)this.currentDBDef(), (String)keyName);
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void lock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Locking the configuration of DBFlute");
        }
        this._locked = true;
    }

    public void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Unlocking the configuration of DBFlute");
        }
        this._locked = false;
    }

    protected void assertNotLocked() {
        if (!this.isLocked()) {
            return;
        }
        String msg = "The configuration of DBFlute is locked.";
        throw new IllegalDBFluteConfigAccessException(msg);
    }

    protected DBDef currentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return DBCurrent.getInstance().isCurrentDBDef(currentDBDef);
    }

    public static class ImplementedSQLExceptionDigger
    implements SQLExceptionDigger {
        public SQLException digUp(Throwable cause) {
            SQLException found = this.resolveS2DBCP(cause);
            if (found != null) {
                return found;
            }
            found = this.resolveDefault(cause);
            if (found != null) {
                return found;
            }
            return null;
        }

        protected SQLException resolveS2DBCP(Throwable cause) {
            Throwable nestedCause;
            if (cause instanceof SQLRuntimeException && (nestedCause = ((SQLRuntimeException)cause).getCause()) instanceof SQLException) {
                return (SQLException)nestedCause;
            }
            return null;
        }

        protected SQLException resolveDefault(Throwable cause) {
            Throwable nestedCause = cause.getCause();
            if (nestedCause instanceof SQLException) {
                return (SQLException)nestedCause;
            }
            return null;
        }
    }

    public static class ImplementedPhysicalConnectionDigger
    implements PhysicalConnectionDigger {
        public Connection digUp(Connection conn) throws SQLException {
            if (conn instanceof NotClosingConnectionWrapper) {
                conn = ((NotClosingConnectionWrapper)conn).getActualConnection();
            }
            conn = this.resolveS2DBCP(conn);
            conn = this.resolveCommonsDBCP(conn);
            return conn;
        }

        protected Connection resolveS2DBCP(Connection conn) {
            if (conn instanceof ConnectionWrapper) {
                conn = ((ConnectionWrapper)conn).getPhysicalConnection();
            }
            return conn;
        }

        protected Connection resolveCommonsDBCP(Connection conn) {
            if ("org.apache.commons.dbcp.PoolingDataSource$PoolGuardConnectionWrapper".equals(conn.getClass().getName())) {
                conn = this.getFieldConnection(conn, "delegate");
            }
            if ("org.apache.commons.dbcp.PoolableConnection".equals(conn.getClass().getName())) {
                conn = this.getFieldConnection(conn, "_conn");
            }
            return conn;
        }

        protected Connection getFieldConnection(Connection conn, String fieldName) {
            Field field = DfReflectionUtil.getWholeField(conn.getClass(), (String)fieldName);
            return (Connection)DfReflectionUtil.getValueForcedly((Field)field, (Object)conn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImplementedOracleStructType
    extends OracleStructType {
        public ImplementedOracleStructType(String structTypeName, Class<?> entityType) {
            super(structTypeName, entityType);
        }

        protected OracleAgent createOracleAgent() {
            return new ImplementedOracleAgent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImplementedOracleArrayType
    extends OracleArrayType {
        public ImplementedOracleArrayType(String arrayTypeName, Class<?> elementType) {
            super(arrayTypeName, elementType);
        }

        protected OracleAgent createOracleAgent() {
            return new ImplementedOracleAgent();
        }
    }

    public static class ImplementedOracleDateType
    extends OracleDateType {
        protected OracleAgent createOracleAgent() {
            return new ImplementedOracleAgent();
        }
    }

    public static class ImplementedOracleAgent
    implements OracleAgent {
        public Object toOracleDate(Timestamp timestamp) {
            throw new UnsupportedOperationException("This method is only for Oracle.");
        }

        public Object toOracleArray(Connection conn, String arrayTypeName, Object arrayValue) throws SQLException {
            throw new UnsupportedOperationException("This method is only for Oracle.");
        }

        public Object toStandardArray(Object oracleArray) throws SQLException {
            throw new UnsupportedOperationException("This method is only for Oracle.");
        }

        public boolean isOracleArray(Object obj) {
            throw new UnsupportedOperationException("This method is only for Oracle.");
        }

        public Object toOracleStruct(Connection conn, String structTypeName, Object[] attrs) throws SQLException {
            throw new UnsupportedOperationException("This method is only for Oracle.");
        }

        public Object[] toStandardStructAttributes(Object oracleStruct) throws SQLException {
            throw new UnsupportedOperationException("This method is only for Oracle.");
        }

        public boolean isOracleStruct(Object obj) {
            throw new UnsupportedOperationException("This method is only for Oracle.");
        }

        public PhysicalConnectionDigger getPhysicalConnectionDigger() {
            return DBFluteConfig.getInstance().getPhysicalConnectionDigger();
        }
    }

    protected static class SpringDBCPDataSourceHandler
    implements DataSourceHandler {
        protected SpringDBCPDataSourceHandler() {
        }

        public Connection getConnection(DataSource ds) throws SQLException {
            Connection conn = this.getConnectionFromUtils(ds);
            if (this.isConnectionTransactional(conn, ds)) {
                return new NotClosingConnectionWrapper(conn);
            }
            return conn;
        }

        public Connection getConnectionFromUtils(DataSource ds) {
            throw new IllegalStateException("This method is only for Spring Framework.");
        }

        public boolean isConnectionTransactional(Connection conn, DataSource ds) {
            throw new IllegalStateException("This method is only for Spring Framework.");
        }

        public String toString() {
            return "SpringDBCPDataSourceHandler(for Spring and Commons-DBCP)";
        }
    }
}

