/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.cbean.coption.ParameterOption;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.QueryDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.SpecifyDerivedReferrer;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.util.DfSystemUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

public class DerivedReferrerOption
implements ParameterOption {
    protected Object _coalesce;
    protected Object _round;
    protected Object _trunc;
    protected LinkedHashMap<String, ProcessCallback> _callbackMap;
    protected String _parameterKey;
    protected String _parameterMapPath;
    protected ColumnInfo _targetColumnInfo;
    protected boolean _databaseMySQL;
    protected boolean _databasePostgreSQL;
    protected boolean _databaseOracle;
    protected boolean _databaseDB2;
    protected boolean _databaseSQLServer;
    protected boolean _databaseH2;
    protected boolean _databaseDerby;

    public DerivedReferrerOption coalesce(Object coalesce) {
        this._coalesce = coalesce;
        this.addProcessCallback("coalesce", new ProcessCallback(){

            public String callback(String functionExp) {
                return DerivedReferrerOption.this.processCoalesce(functionExp);
            }
        });
        return this;
    }

    public DerivedReferrerOption round(Object round) {
        this._round = round;
        this.addProcessCallback("round", new ProcessCallback(){

            public String callback(String functionExp) {
                return DerivedReferrerOption.this.processRound(functionExp);
            }
        });
        return this;
    }

    public DerivedReferrerOption trunc(Object trunc) {
        this._trunc = trunc;
        this.addProcessCallback("trunc", new ProcessCallback(){

            public String callback(String functionExp) {
                return DerivedReferrerOption.this.processTrunc(functionExp);
            }
        });
        return this;
    }

    public String filterFunction(String functionExp) {
        String filtered = functionExp;
        LinkedHashMap<String, ProcessCallback> callbackMap = this._callbackMap;
        if (callbackMap != null) {
            Set<Map.Entry<String, ProcessCallback>> entrySet = callbackMap.entrySet();
            for (Map.Entry<String, ProcessCallback> entry : entrySet) {
                filtered = entry.getValue().callback(filtered);
            }
        }
        return this.processVarious(filtered);
    }

    protected void addProcessCallback(String functionKey, ProcessCallback callback) {
        if (this._callbackMap == null) {
            this._callbackMap = new LinkedHashMap();
        }
        if (this._callbackMap.containsKey(functionKey)) {
            String msg = "The function has been already set up: ";
            msg = msg + "function=" + functionKey + "() option=" + this.toString();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._callbackMap.put(functionKey, callback);
    }

    protected String processCoalesce(String functionExp) {
        if (this._coalesce instanceof String && this.isDateTypeColumn()) {
            this._coalesce = DfTypeUtil.toDate(this._coalesce);
        }
        String functionName = "coalesce";
        String propertyName = "coalesce";
        return this.processSimpleFunction(functionExp, this._coalesce, "coalesce", "coalesce", null, false);
    }

    protected String processRound(String functionExp) {
        String functionName = "round";
        String propertyName = "round";
        return this.processSimpleFunction(functionExp, this._round, "round", "round", null, false);
    }

    protected String processTrunc(String functionExp) {
        boolean leftArg;
        String thirdArg;
        String functionName;
        if (this.isTruncTrancate()) {
            functionName = "truncate";
            thirdArg = null;
            leftArg = false;
        } else if (this.isDatabaseSQLServer()) {
            functionName = "round";
            thirdArg = "1";
            leftArg = false;
        } else if (this.isDatabasePostgreSQL() && this.isDateTypeColumn()) {
            functionName = "date_trunc";
            thirdArg = null;
            leftArg = true;
        } else {
            functionName = "trunc";
            thirdArg = null;
            leftArg = false;
        }
        return this.processSimpleFunction(functionExp, this._trunc, functionName, "trunc", thirdArg, leftArg);
    }

    protected boolean isTruncTrancate() {
        return this.isDatabaseMySQL() || this.isDatabaseH2();
    }

    protected String processVarious(String functionExp) {
        return functionExp;
    }

    protected String processSimpleFunction(String functionExp, Object specifiedValue, String functionName, String propertyName, String thirdArg, boolean leftArg) {
        String pureFunction;
        if (specifiedValue == null) {
            return functionExp;
        }
        String bindParameter = this.buildBindParameter(propertyName);
        StringBuilder sb = new StringBuilder();
        sb.append(functionName).append("(");
        String sqend = "--#df:sqend#";
        boolean handleSqEnd = this.hasSubQueryEndOnLastLine(functionExp);
        String string = pureFunction = handleSqEnd ? Srl.substringLastFront(functionExp, "--#df:sqend#") : functionExp;
        if (leftArg) {
            String indent = Srl.indent("select ".length());
            sb.append(bindParameter).append(this.ln()).append(indent).append(", ").append(pureFunction);
        } else {
            sb.append(pureFunction).append(", ").append(bindParameter);
        }
        if (Srl.is_NotNull_and_NotTrimmedEmpty(thirdArg)) {
            sb.append(", ").append(thirdArg);
        }
        sb.append(")");
        if (handleSqEnd) {
            sb.append("--#df:sqend#").append(Srl.substringLastRear(functionExp, "--#df:sqend#"));
        }
        return sb.toString();
    }

    protected boolean hasSubQueryEndOnLastLine(String functionExp) {
        return SubQueryIndentProcessor.hasSubQueryEndOnLastLine(functionExp);
    }

    protected String buildBindParameter(String propertyName) {
        return "/*pmb." + this._parameterMapPath + "." + this._parameterKey + "." + propertyName + "*/null";
    }

    protected boolean isDateTypeColumn() {
        return this._targetColumnInfo != null && Date.class.isAssignableFrom(this._targetColumnInfo.getPropertyType());
    }

    public void acceptParameterKey(String parameterKey, String parameterMapPath) {
        this._parameterKey = parameterKey;
        this._parameterMapPath = parameterMapPath;
    }

    public SpecifyDerivedReferrer createSpecifyDerivedReferrer(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, String subQueryIdentity, DBMeta subQueryDBMeta, String mainSubQueryIdentity, String aliasName) {
        return new SpecifyDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, aliasName);
    }

    public QueryDerivedReferrer createQueryDerivedReferrer(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQueryClause, String subQueryIdentity, DBMeta subQueryDBMeta, String mainSubQueryIdentity, String operand, Object value, String parameterPath) {
        return new QueryDerivedReferrer(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQueryClause, subQueryIdentity, subQueryDBMeta, mainSubQueryIdentity, operand, value, parameterPath);
    }

    protected final String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        return title + ":{coalesce=" + this._coalesce + ", round=" + this._round + ", trunc=" + this._trunc + "}";
    }

    public Object getCoalesce() {
        return this._coalesce;
    }

    public Object getRound() {
        return this._round;
    }

    public Object getTrunc() {
        return this._trunc;
    }

    public void setTargetColumnInfo(ColumnInfo targetColumnInfo) {
        this._targetColumnInfo = targetColumnInfo;
    }

    protected boolean isDatabaseMySQL() {
        return this._databaseMySQL;
    }

    public void setDatabaseMySQL(boolean databaseMySQL) {
        this._databaseMySQL = databaseMySQL;
    }

    protected boolean isDatabasePostgreSQL() {
        return this._databasePostgreSQL;
    }

    public void setDatabasePostgreSQL(boolean databasePostgreSQL) {
        this._databasePostgreSQL = databasePostgreSQL;
    }

    protected boolean isDatabaseOracle() {
        return this._databaseOracle;
    }

    public void setDatabaseOracle(boolean databaseOracle) {
        this._databaseOracle = databaseOracle;
    }

    protected boolean isDatabaseDB2() {
        return this._databaseDB2;
    }

    public void setDatabaseDB2(boolean databaseDB2) {
        this._databaseDB2 = databaseDB2;
    }

    protected boolean isDatabaseSQLServer() {
        return this._databaseSQLServer;
    }

    public void setDatabaseSQLServer(boolean databaseSQLServer) {
        this._databaseSQLServer = databaseSQLServer;
    }

    protected boolean isDatabaseH2() {
        return this._databaseH2;
    }

    public void setDatabaseH2(boolean databaseH2) {
        this._databaseH2 = databaseH2;
    }

    protected boolean isDatabaseDerby() {
        return this._databaseDerby;
    }

    public void setDatabaseDerby(boolean databaseDerby) {
        this._databaseDerby = databaseDerby;
    }

    protected static interface ProcessCallback {
        public String callback(String var1);
    }
}

