/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfExtractor
implements Extractor {
    protected String encoding = "UTF-8";
    protected boolean force = false;
    protected Map<String, String> passwordMap = new HashMap<String, String>();

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        PDDocument document = null;
        try {
            ExtractData extractData;
            document = PDDocument.load((InputStream)in, null, (boolean)this.force);
            if (document.isEncrypted() && params != null) {
                String password = params.get("org.apache.tika.parser.pdf.password");
                if (password == null) {
                    password = this.getPassword(params.get("url"), params.get("resourceName"));
                }
                if (password != null) {
                    StandardDecryptionMaterial sdm = new StandardDecryptionMaterial(password);
                    document.openProtection((DecryptionMaterial)sdm);
                    AccessPermission ap = document.getCurrentAccessPermission();
                    if (!ap.canExtractContent()) {
                        throw new IOException("You do not have permission to extract text.");
                    }
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)baos, this.encoding);
            PDFTextStripper stripper = new PDFTextStripper(this.encoding);
            stripper.setForceParsing(this.force);
            stripper.writeText(document, (Writer)output);
            ((Writer)output).flush();
            ExtractData extractData2 = extractData = new ExtractData(baos.toString(this.encoding));
            return extractData2;
        }
        catch (Exception e) {
            throw new ExtractException(e);
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void extractMetadata(PDDocument document, ExtractData extractData) throws TikaException {
        PDDocumentInformation info = document.getDocumentInformation();
        this.addMetadata(extractData, "title", info.getTitle());
        this.addMetadata(extractData, "Author", info.getAuthor());
        this.addMetadata(extractData, "creator", info.getCreator());
        this.addMetadata(extractData, "Keywords", info.getKeywords());
        this.addMetadata(extractData, "producer", info.getProducer());
        this.addMetadata(extractData, "subject", info.getSubject());
        this.addMetadata(extractData, "trapped", info.getTrapped());
        try {
            this.addMetadata(extractData, "created", info.getCreationDate());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Calendar modified = info.getModificationDate();
            this.addMetadata(extractData, Metadata.LAST_MODIFIED.toString(), modified);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void addMetadata(ExtractData extractData, String name, String value) {
        if (value != null) {
            extractData.putValue(name, value);
        }
    }

    private void addMetadata(ExtractData extractData, String name, Calendar value) {
        if (value != null) {
            extractData.putValue(name, value.getTime().toString());
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void addPassword(String regex, String password) {
        this.passwordMap.put(regex, password);
    }

    String getPassword(String url, String resourceName) {
        if (this.passwordMap.size() == 0) {
            return null;
        }
        String value = null;
        if (StringUtil.isNotEmpty((String)url)) {
            value = url;
        } else if (StringUtil.isNotEmpty((String)resourceName)) {
            value = resourceName;
        }
        if (value != null) {
            for (Map.Entry<String, String> entry : this.passwordMap.entrySet()) {
                if (!value.matches(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

