/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.seasar.framework.beans.ParameterizedClassDesc;
import org.seasar.framework.beans.factory.ParameterizedClassDescFactory;
import org.seasar.framework.beans.impl.ParameterizedClassDescImpl;
import org.seasar.framework.util.tiger.GenericUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedClassDescFactoryProvider
implements ParameterizedClassDescFactory.Provider {
    public Map<TypeVariable<?>, Type> getTypeVariables(Class beanClass) {
        return GenericUtil.getTypeVariableMap(beanClass);
    }

    public ParameterizedClassDesc createParameterizedClassDesc(Field field, Map map) {
        return this.createParameterizedClassDesc(field.getGenericType(), map);
    }

    public ParameterizedClassDesc createParameterizedClassDesc(Method method, int index, Map map) {
        return this.createParameterizedClassDesc(method.getGenericParameterTypes()[index], map);
    }

    public ParameterizedClassDesc createParameterizedClassDesc(Method method, Map map) {
        return this.createParameterizedClassDesc(method.getGenericReturnType(), map);
    }

    public ParameterizedClassDesc createParameterizedClassDesc(Type type, Map<TypeVariable<?>, Type> map) {
        Class<?> rowClass = GenericUtil.getActualClass(type, map);
        if (rowClass == null) {
            return null;
        }
        ParameterizedClassDescImpl desc = new ParameterizedClassDescImpl(rowClass);
        Type[] parameterTypes = GenericUtil.getGenericParameter(type);
        if (parameterTypes == null) {
            return desc;
        }
        ParameterizedClassDesc[] parameterDescs = new ParameterizedClassDesc[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterDescs[i] = this.createParameterizedClassDesc(parameterTypes[i], map);
        }
        desc.setArguments(parameterDescs);
        return desc;
    }
}

