/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.mail.config.MailConfig;
import org.mobylet.mail.detector.MailCarrierDetector;
import org.mobylet.mail.message.MobyletMessage;

public class MobyletMailer {
    public static MobyletMessage createMessage(String to) {
        MailConfig config = (MailConfig)SingletonUtils.get(MailConfig.class);
        Session session = config.createSession();
        MailCarrierDetector carrierDetector = (MailCarrierDetector)SingletonUtils.get(MailCarrierDetector.class);
        Carrier carrier = carrierDetector.getCarrierByAddress(to);
        MobyletMessage message = new MobyletMessage(carrier, session);
        return message.to(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobyletMessage send(MobyletMessage message) {
        message = message.construct();
        try {
            message.saveChanges();
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u518d\u7de8\u4e2d\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
        }
        Session session = message.getSession();
        Transport transport = null;
        try {
            transport = session.getTransport("smtp");
            if ("true".equals(session.getProperty("mail.smtp.auth"))) {
                transport.connect(session.getProperty("mail.smtp.host"), session.getProperty("mail.smtp.user"), session.getProperty("mail.smtp.pass"));
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)message, message.getAllRecipients());
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException messagingException) {}
            }
        }
        return message;
    }
}

