/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.BindingUtil;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.StringUtil;

public class DependencyLookupInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> clazz;
        Object[] components;
        Object component;
        ComponentDef cd;
        Method method = invocation.getMethod();
        String methodName = method.getName();
        Class<?> propType = method.getReturnType();
        if (!methodName.startsWith("get") || method.getParameterTypes().length != 0 || propType == null) {
            throw new IllegalStateException(MessageFormatter.getSimpleMessage("ESSR0103", new Object[]{method}));
        }
        S2Container container = this.getComponentDef(invocation).getContainer();
        String propName = StringUtil.decapitalize(methodName.substring(3));
        if (container.hasComponentDef(propType) && this.isAutoBindable(propName, propType, cd = container.getComponentDef(propType))) {
            return cd.getComponent();
        }
        if (container.hasComponentDef(propName) && propType.isInstance(component = (cd = container.getComponentDef(propName)).getComponent())) {
            return component;
        }
        if (BindingUtil.isAutoBindable(propType) && container.hasComponentDef(propType)) {
            cd = container.getComponentDef(propType);
            return cd.getComponent();
        }
        if (BindingUtil.isAutoBindableArray(propType) && (components = container.findAllComponents(clazz = propType.getComponentType())).length > 0) {
            return components;
        }
        throw new ComponentNotFoundRuntimeException((Object)propName);
    }

    protected boolean isAutoBindable(String propertyName, Class propertyType, ComponentDef cd) {
        return cd.getComponentName() != null && (cd.getComponentName().equalsIgnoreCase(propertyName) || StringUtil.endsWithIgnoreCase(cd.getComponentName(), '_' + propertyName));
    }
}

