/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.util;

import java.io.ByteArrayOutputStream;
import org.mobylet.core.util.StringUtils;

public class Base64Utils {
    public static final char[] c = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static String encode(byte[] data) {
        int d;
        int i;
        StringBuilder buf = new StringBuilder(data.length * 3 / 2);
        int end = data.length - 3;
        int breakNumber = 0;
        for (i = 0; i <= end; i += 3) {
            d = (data[i] & 0xFF) << 16 | (data[i + 1] & 0xFF) << 8 | data[i + 2] & 0xFF;
            buf.append(c[d >> 18 & 0x3F]);
            buf.append(c[d >> 12 & 0x3F]);
            buf.append(c[d >> 6 & 0x3F]);
            buf.append(c[d & 0x3F]);
            if (breakNumber++ < 14) continue;
            breakNumber = 0;
            buf.append("\r\n");
        }
        if (i == end + 1) {
            d = (data[i] & 0xFF) << 16 | (data[i + 1] & 0xFF) << 8;
            buf.append(c[d >> 18 & 0x3F]);
            buf.append(c[d >> 12 & 0x3F]);
            buf.append(c[d >> 6 & 0x3F]);
            buf.append("=");
        } else if (i == end + 2) {
            d = (data[i] & 0xFF) << 16;
            buf.append(c[d >> 18 & 0x3F]);
            buf.append(c[d >> 12 & 0x3F]);
            buf.append("==");
        }
        return buf.toString();
    }

    public static byte[] decode(String base64String) {
        if (StringUtils.isEmpty((String)base64String)) {
            return new byte[0];
        }
        String s = base64String.trim();
        int len = s.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(s.length() * 2 / 3 + 1);
        for (int i = 0; i != len; i += 4) {
            int tri = (Base64Utils.decode(s.charAt(i)) << 18) + (Base64Utils.decode(s.charAt(i + 1)) << 12) + (Base64Utils.decode(s.charAt(i + 2)) << 6) + Base64Utils.decode(s.charAt(i + 3));
            os.write(tri >> 16 & 0xFF);
            if (s.charAt(i + 2) == '=') break;
            os.write(tri >> 8 & 0xFF);
            if (s.charAt(i + 3) == '=') break;
            os.write(tri & 0xFF);
        }
        return os.toByteArray();
    }

    private static int decode(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 26 + 26;
        }
        switch (c) {
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
            case '=': {
                return 0;
            }
        }
        throw new RuntimeException("\u89e3\u6790\u4e0d\u53ef\u80fd char = " + c);
    }
}

