/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.stacktrace.impl;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractor;
import org.seasar.dbflute.helper.stacktrace.InvokeNameResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeNameExtractorImpl
implements InvokeNameExtractor {
    protected StackTraceElement[] _stackTrace;

    @Override
    public List<InvokeNameResult> extractInvokeName(InvokeNameExtractingResource resource) {
        if (this._stackTrace == null) {
            String msg = "The attribute 'stackTrace' should not be null: resource=" + resource;
            throw new IllegalStateException(msg);
        }
        ArrayList<InvokeNameResult> resultList = new ArrayList<InvokeNameResult>();
        String simpleClassName = null;
        String methodName = null;
        int lineNumber = 0;
        int foundIndex = -1;
        int foundFirstIndex = -1;
        boolean onTarget = false;
        boolean existsDuplicate = false;
        for (int i = resource.getStartIndex(); i < this._stackTrace.length; ++i) {
            StackTraceElement element = this._stackTrace[i];
            if (i > resource.getStartIndex() + resource.getLoopSize()) break;
            String currentClassName = element.getClassName();
            if (currentClassName.startsWith("sun.") || currentClassName.startsWith("java.")) {
                if (!onTarget) continue;
                break;
            }
            String currentMethodName = element.getMethodName();
            if (resource.isTargetElement(currentClassName, currentMethodName)) {
                if (currentMethodName.equals("invoke")) continue;
                simpleClassName = currentClassName.substring(currentClassName.lastIndexOf(".") + 1);
                simpleClassName = resource.filterSimpleClassName(simpleClassName);
                methodName = currentMethodName;
                if (resource.isUseAdditionalInfo()) {
                    lineNumber = element.getLineNumber();
                }
                foundIndex = i;
                if (foundFirstIndex == -1) {
                    foundFirstIndex = i;
                }
                onTarget = true;
                if (resultList.isEmpty()) {
                    resultList.add(this.createResult(simpleClassName, methodName, lineNumber, foundIndex, foundFirstIndex));
                    continue;
                }
                existsDuplicate = true;
                continue;
            }
            if (onTarget) break;
        }
        if (simpleClassName == null) {
            return new ArrayList<InvokeNameResult>();
        }
        if (existsDuplicate) {
            resultList.add(this.createResult(simpleClassName, methodName, lineNumber, foundIndex, foundFirstIndex));
        }
        return resultList;
    }

    private InvokeNameResult createResult(String simpleClassName, String methodName, int lineNumber, int foundIndex, int foundFirstIndex) {
        InvokeNameResult result = new InvokeNameResult();
        result.setSimpleClassName(simpleClassName);
        result.setMethodName(methodName);
        String invokeName = lineNumber > 0 ? simpleClassName + "." + methodName + "():" + lineNumber + " -> " : simpleClassName + "." + methodName + "() -> ";
        result.setInvokeName(invokeName);
        result.setFoundIndex(foundIndex);
        result.setFoundFirstIndex(foundFirstIndex);
        return result;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this._stackTrace = stackTrace;
    }
}

