/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.seasar.dbflute.s2dao.rowcreator.TnRowCreator;
import org.seasar.dbflute.s2dao.rshandler.TnBeanListResultSetHandler;
import org.seasar.dbflute.s2dao.rshandler.TnRelationRowCache;
import org.seasar.dbflute.s2dao.rshandler.TnRelationRowNonCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBeanCursorResultSetHandler
extends TnBeanListResultSetHandler {
    public TnBeanCursorResultSetHandler(TnBeanMetaData beanMetaData, TnRowCreator rowCreator, TnRelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator, relationRowCreator);
    }

    @Override
    public Object handle(ResultSet rs) throws SQLException {
        if (!this.hasEntityRowHandler()) {
            String msg = "Bean cursor handling should have condition-bean!";
            throw new IllegalStateException(msg);
        }
        final EntityRowHandler<Entity> entityRowHandler = this.getEntityRowHandler();
        this.mappingBean(rs, new TnBeanListResultSetHandler.BeanRowHandler(){

            public void handle(Object row) throws SQLException {
                if (!(row instanceof Entity)) {
                    String msg = "The row object should be an entity at bean cursor handling:";
                    msg = msg + " row=" + (row != null ? row.getClass().getName() + ":" + row : null);
                    throw new IllegalStateException(msg);
                }
                entityRowHandler.handle((Entity)row);
            }
        });
        return null;
    }

    @Override
    protected TnRelationRowCache createRelationRowCache(int relSize) {
        return new TnRelationRowNonCache(relSize);
    }

    protected boolean hasEntityRowHandler() {
        return ConditionBeanContext.isExistEntityRowHandlerOnThread();
    }

    protected EntityRowHandler<Entity> getEntityRowHandler() {
        EntityRowHandler<Entity> handlerOnThread;
        EntityRowHandler<Entity> entityRowHandler = handlerOnThread = ConditionBeanContext.getEntityRowHandlerOnThread();
        return entityRowHandler;
    }
}

