/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.FloatLookupContainer;
import com.carrotsearch.hppc.FloatSet;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class FloatOpenHashSet
extends AbstractFloatCollection
implements FloatLookupContainer,
FloatSet,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public float[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public FloatOpenHashSet() {
        this(16, 0.75f);
    }

    public FloatOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public FloatOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public FloatOpenHashSet(FloatContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(float e) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(e, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = e;
        }
        return true;
    }

    public int add(float e1, float e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(float ... elements) {
        int count = 0;
        for (float e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(FloatContainer container) {
        return this.addAll((Iterable<? extends FloatCursor>)container);
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int count = 0;
        for (FloatCursor floatCursor : iterable) {
            if (!this.add(floatCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(float pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        float[] oldKeys = this.keys;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        float[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            float k = oldKeys[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
        }
    }

    private void allocateBuffers(int capacity) {
        float[] keys = new float[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int removeAllOccurrences(float key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(float key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        return this.lastSlot;
    }

    @Override
    public boolean contains(float key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, 0.0f);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        float[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            FloatSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof FloatSet && (other = (FloatSet)obj).size() == this.size()) {
                for (FloatCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        float[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public float[] toArray() {
        float[] cloned = new float[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public FloatOpenHashSet clone() {
        try {
            FloatOpenHashSet cloned = (FloatOpenHashSet)super.clone();
            cloned.keys = (float[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        float[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        float[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static FloatOpenHashSet from(float ... elements) {
        FloatOpenHashSet set = new FloatOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static FloatOpenHashSet from(FloatContainer container) {
        return new FloatOpenHashSet(container);
    }

    public static FloatOpenHashSet newInstance() {
        return new FloatOpenHashSet();
    }

    public static FloatOpenHashSet newInstanceWithoutPerturbations() {
        return new FloatOpenHashSet(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static FloatOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new FloatOpenHashSet(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            int max = FloatOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < FloatOpenHashSet.this.keys.length && !FloatOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

