/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.sqlclause.join.FixedConditionResolver;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.DBMetaProvider;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.exception.DBMetaNotFoundException;
import org.seasar.dbflute.exception.FixedConditionIllegalOverRelationException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.Srl;

public class HpFixedConditionQueryResolver
implements FixedConditionResolver {
    public static final String LOCAL_ALIAS_MARK = "$$localAlias$$";
    public static final String FOREIGN_ALIAS_MARK = "$$foreignAlias$$";
    public static final String SQ_BEGIN_MARK = "$$sqbegin$$";
    public static final String SQ_END_MARK = "$$sqend$$";
    public static final String LOCATION_BASE_MARK = "$$locationBase$$";
    protected final ConditionQuery _localCQ;
    protected final ConditionQuery _foreignCQ;
    protected final DBMetaProvider _dbmetaProvider;
    protected Map<String, InlineViewResource> _inlineViewResourceMap;

    public HpFixedConditionQueryResolver(ConditionQuery localCQ, ConditionQuery foreignCQ, DBMetaProvider dbmetaProvider) {
        this._localCQ = localCQ;
        this._foreignCQ = foreignCQ;
        this._dbmetaProvider = dbmetaProvider;
    }

    @Override
    public String resolveVariable(String fixedCondition, boolean fixedInline) {
        fixedCondition = this.filterBasicMark(fixedCondition, fixedInline);
        fixedCondition = this.filterSubQueryIndentMark(fixedCondition, fixedInline);
        fixedCondition = this.filterLocationMark(fixedCondition, fixedInline);
        fixedCondition = this.resolveFixedConditionOverRelation(fixedCondition, fixedInline);
        return fixedCondition;
    }

    protected String filterBasicMark(String fixedCondition, boolean fixedInline) {
        String localAliasName = this._localCQ.xgetAliasName();
        String foreignAliasName = this._foreignCQ.xgetAliasName();
        fixedCondition = this.replaceString(fixedCondition, "$$alias$$", foreignAliasName);
        fixedCondition = this.replaceString(fixedCondition, this.getLocalAliasMark(), localAliasName);
        fixedCondition = this.replaceString(fixedCondition, this.getForeignAliasMark(), foreignAliasName);
        return fixedCondition;
    }

    protected String filterSubQueryIndentMark(String fixedCondition, boolean fixedInline) {
        String sqBeginMark = this.getSqBeginMark();
        String sqEndMark = this.getSqEndMark();
        if (!fixedCondition.contains(sqBeginMark) || !fixedCondition.contains(sqEndMark)) {
            return fixedCondition;
        }
        String sqEndIndent = this.getSqEndIndent(fixedInline);
        String indentFrom = "\n)" + sqEndMark;
        String indentTo = "\n" + sqEndIndent + ")" + sqEndMark;
        fixedCondition = Srl.replace(fixedCondition, indentFrom, indentTo);
        SubQueryIndentProcessor processor = new SubQueryIndentProcessor();
        String foreignAliasName = this._foreignCQ.xgetAliasName();
        String subQueryIdentity = "fixed_" + foreignAliasName;
        String beginMark = processor.resolveSubQueryBeginMark(subQueryIdentity);
        fixedCondition = Srl.replace(fixedCondition, sqBeginMark, beginMark);
        String endMark = processor.resolveSubQueryEndMark(subQueryIdentity);
        fixedCondition = Srl.replace(fixedCondition, sqEndMark, endMark);
        return fixedCondition;
    }

    protected String getSqEndIndent(boolean fixedInline) {
        String indent = fixedInline ? "                            " : "         ";
        return indent;
    }

    protected String filterLocationMark(String fixedCondition, boolean fixedInline) {
        String locationBase = this._localCQ.xgetLocationBase();
        return this.replaceString(fixedCondition, this.getLocationBaseMark() + ".", "pmb." + locationBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String resolveFixedConditionOverRelation(String fixedCondition, boolean fixedInline) {
        String relationBeginMark = this.getRelationBeginMark();
        String relationEndMark = this.getRelationEndMark();
        String remainder = fixedCondition;
        Srl.IndexOfInfo relationBeginIndex;
        while ((relationBeginIndex = Srl.indexOfFirst(remainder, relationBeginMark)) != null) {
            ConditionQuery columnTargetCQ;
            String notice;
            ConditionQuery relationPointCQ;
            String secondArg;
            String targetRelation;
            Srl.IndexOfInfo argIndex;
            String pointTable;
            remainder = relationBeginIndex.substringRear();
            Srl.IndexOfInfo relationEndIndex = Srl.indexOfFirst(remainder, relationEndMark);
            if (relationEndIndex == null) {
                return fixedCondition;
            }
            String relationExp = relationEndIndex.substringFront();
            Srl.IndexOfInfo separatorIndex = Srl.indexOfFirst(relationExp, ".");
            if (separatorIndex != null) {
                pointTable = separatorIndex.substringFrontTrimmed();
                argIndex = Srl.indexOfFirst(separatorIndex.substringRearTrimmed(), ",");
                targetRelation = argIndex != null ? argIndex.substringFrontTrimmed() : separatorIndex.substringRearTrimmed();
                secondArg = argIndex != null ? argIndex.substringRearTrimmed() : null;
            } else {
                argIndex = Srl.indexOfFirst(relationExp, ",");
                pointTable = argIndex != null ? argIndex.substringFrontTrimmed() : Srl.trim(relationExp);
                targetRelation = null;
                String string = secondArg = argIndex != null ? argIndex.substringRearTrimmed() : null;
            }
            if (Srl.equalsPlain(pointTable, this.getLocalTableMark())) {
                relationPointCQ = this._localCQ;
                if (targetRelation == null) {
                    notice = "The relation on fixed condition is required if the table is not referrer.";
                    this.throwIllegalFixedConditionOverRelationException(notice, pointTable, null, fixedCondition);
                    return null;
                }
                columnTargetCQ = this.invokeColumnTargetCQ(relationPointCQ, targetRelation);
            } else if (Srl.equalsPlain(pointTable, this.getForeignTableMark())) {
                InlineViewResource resource;
                columnTargetCQ = relationPointCQ = this._foreignCQ;
                if (targetRelation == null) {
                    notice = "The relation on fixed condition is required if the table is not referrer.";
                    this.throwIllegalFixedConditionOverRelationException(notice, pointTable, null, fixedCondition);
                    return null;
                }
                if (this._inlineViewResourceMap == null) {
                    this._inlineViewResourceMap = new LinkedHashMap<String, InlineViewResource>();
                }
                if (this._inlineViewResourceMap.containsKey(targetRelation)) {
                    resource = this._inlineViewResourceMap.get(targetRelation);
                } else {
                    resource = new InlineViewResource();
                    this._inlineViewResourceMap.put(targetRelation, resource);
                }
                Srl.IndexOfInfo rearIndex = Srl.indexOfFirst(relationEndIndex.substringRearTrimmed(), ".");
                if (rearIndex == null || rearIndex.getIndex() > 0) {
                    String notice2 = "The OverRelation variable should continue to column after the variable.";
                    this.throwIllegalFixedConditionOverRelationException(notice2, pointTable, targetRelation, fixedCondition);
                    return null;
                }
                String columnStart = rearIndex.substringRear();
                Srl.IndexOfInfo indexInfo = Srl.indexOfFirst(columnStart, " ", ",", ")", "\n", "\t");
                String columnName = indexInfo != null ? indexInfo.substringFront() : columnStart;
                String resolvedColumn = secondArg != null ? secondArg + " as " + columnName : columnName;
                resource.addAdditionalColumn(resolvedColumn);
                List<String> splitList = Srl.splitList(targetRelation, ".");
                DBMeta currentDBMeta = this._dbmetaProvider.provideDBMeta(this._foreignCQ.getTableDbName());
                for (String element : splitList) {
                    ForeignInfo foreignInfo = currentDBMeta.findForeignInfo(element);
                    resource.addJoinInfo(foreignInfo);
                    currentDBMeta = foreignInfo.getForeignDBMeta();
                }
            } else {
                ConditionQuery referrerQuery;
                String notice3;
                DBMeta pointDBMeta;
                try {
                    pointDBMeta = this._dbmetaProvider.provideDBMeta(pointTable);
                }
                catch (DBMetaNotFoundException e) {
                    notice3 = "The table for relation on fixed condition does not exist.";
                    this.throwIllegalFixedConditionOverRelationException(notice3, pointTable, targetRelation, fixedCondition, e);
                    return null;
                }
                for (referrerQuery = this._localCQ.xgetReferrerQuery(); referrerQuery != null && !Srl.equalsPlain(pointDBMeta.getTableDbName(), referrerQuery.getTableDbName()); referrerQuery = referrerQuery.xgetReferrerQuery()) {
                }
                relationPointCQ = referrerQuery;
                if (relationPointCQ == null) {
                    notice3 = "The table for relation on fixed condition was not found in the scope.";
                    this.throwIllegalFixedConditionOverRelationException(notice3, pointTable, targetRelation, fixedCondition);
                    return null;
                }
                columnTargetCQ = targetRelation != null ? this.invokeColumnTargetCQ(relationPointCQ, targetRelation) : relationPointCQ;
            }
            String relationVariable = relationBeginMark + relationExp + relationEndMark;
            String relationAlias = columnTargetCQ.xgetAliasName();
            fixedCondition = this.replaceString(fixedCondition, relationVariable, relationAlias);
            remainder = relationEndIndex.substringRear();
            remainder = this.replaceString(remainder, relationVariable, relationAlias);
        }
        return fixedCondition;
    }

    protected ConditionQuery invokeColumnTargetCQ(ConditionQuery relationPointCQ, String targetRelation) {
        return relationPointCQ.invokeForeignCQ(targetRelation);
    }

    @Override
    public String resolveFixedInlineView(String foreignTableSqlName, boolean treatedAsInnerJoin) {
        if (this._inlineViewResourceMap == null || this._inlineViewResourceMap.isEmpty()) {
            return foreignTableSqlName;
        }
        String baseAlias = "dffixedbase";
        String baseIndent = treatedAsInnerJoin ? "               " : "                    ";
        StringBuilder joinSb = new StringBuilder();
        HashMap<ForeignInfo, String> relationMap = new HashMap<ForeignInfo, String>();
        ArrayList<String> additionalRealColumnList = new ArrayList<String>();
        int groupIndex = 0;
        for (InlineViewResource resource : this._inlineViewResourceMap.values()) {
            List<ForeignInfo> joinInfoList = resource.getJoinInfoList();
            String aliasBase = "dffixedjoin";
            String preForeignAlias = null;
            String foreignAlias = null;
            int joinIndex = 0;
            for (ForeignInfo joinInfo : joinInfoList) {
                if (relationMap.containsKey(joinInfo)) {
                    preForeignAlias = (String)relationMap.get(joinInfo);
                    continue;
                }
                DBMeta foreignDBMeta = joinInfo.getForeignDBMeta();
                TableSqlName foreignTable = foreignDBMeta.getTableSqlName();
                String localAlias = preForeignAlias != null ? preForeignAlias : "dffixedbase";
                preForeignAlias = foreignAlias = "dffixedjoin_" + groupIndex + "_" + joinIndex;
                joinSb.append(this.ln()).append(baseIndent);
                joinSb.append("     left outer join ").append(foreignTable).append(" ").append(foreignAlias);
                joinSb.append(" on ");
                Map<ColumnInfo, ColumnInfo> columnInfoMap = joinInfo.getLocalForeignColumnInfoMap();
                int columnIndex = 0;
                for (Map.Entry<ColumnInfo, ColumnInfo> localForeignEntry : columnInfoMap.entrySet()) {
                    ColumnInfo localColumnInfo = localForeignEntry.getKey();
                    ColumnInfo foreignColumninfo = localForeignEntry.getValue();
                    if (columnIndex > 0) {
                        joinSb.append(" and ");
                    }
                    joinSb.append(localAlias).append(".").append(localColumnInfo.getColumnSqlName());
                    joinSb.append(" = ").append(foreignAlias).append(".").append(foreignColumninfo.getColumnSqlName());
                    ++columnIndex;
                }
                relationMap.put(joinInfo, foreignAlias);
                ++joinIndex;
            }
            Set<String> additionalColumnSet = resource.getAdditionalColumnSet();
            for (String columnName : additionalColumnSet) {
                additionalRealColumnList.add(foreignAlias + "." + columnName);
            }
            ++groupIndex;
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("(select ").append("dffixedbase").append(".*");
        for (String columnName : additionalRealColumnList) {
            sqlSb.append(", ").append(columnName);
        }
        sqlSb.append(this.ln()).append(baseIndent);
        sqlSb.append("   from ").append(foreignTableSqlName).append(" ").append("dffixedbase");
        sqlSb.append((CharSequence)joinSb);
        sqlSb.append(this.ln()).append(baseIndent);
        sqlSb.append(")");
        return sqlSb.toString();
    }

    protected void throwIllegalFixedConditionOverRelationException(String notice, String tableName, String relationName, String fixedCondition) {
        this.throwIllegalFixedConditionOverRelationException(notice, tableName, relationName, fixedCondition, null);
    }

    protected void throwIllegalFixedConditionOverRelationException(String notice, String pointTable, String targetRelation, String fixedCondition, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Point Table");
        br.addElement(pointTable);
        br.addItem("Target Relation");
        br.addElement(targetRelation);
        br.addItem("Fixed Condition");
        br.addElement(fixedCondition);
        br.addItem("BizOneToOne's Local");
        br.addElement(this._localCQ.getTableDbName());
        String msg = br.buildExceptionMessage();
        throw new FixedConditionIllegalOverRelationException(msg, e);
    }

    @Override
    public boolean hasOverRelation(String fixedCondition) {
        String relationBeginMark = this.getRelationBeginMark();
        String relationEndMark = this.getRelationEndMark();
        return Srl.containsAll(fixedCondition, relationBeginMark, relationEndMark);
    }

    protected String getLocalAliasMark() {
        return LOCAL_ALIAS_MARK;
    }

    protected String getForeignAliasMark() {
        return FOREIGN_ALIAS_MARK;
    }

    protected String getSqBeginMark() {
        return SQ_BEGIN_MARK;
    }

    protected String getSqEndMark() {
        return SQ_END_MARK;
    }

    protected String getLocationBaseMark() {
        return LOCATION_BASE_MARK;
    }

    protected String getRelationBeginMark() {
        return "$$over(";
    }

    protected String getRelationEndMark() {
        return ")$$";
    }

    protected String getLocalTableMark() {
        return "$localTable";
    }

    protected String getForeignTableMark() {
        return "$foreignTable";
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected static class InlineViewResource {
        protected Set<String> _additionalColumnSet;
        protected List<ForeignInfo> _joinInfoList;

        protected InlineViewResource() {
        }

        public Set<String> getAdditionalColumnSet() {
            return this._additionalColumnSet;
        }

        public void addAdditionalColumn(String additionalColumn) {
            if (this._additionalColumnSet == null) {
                this._additionalColumnSet = new LinkedHashSet<String>();
            }
            this._additionalColumnSet.add(additionalColumn);
        }

        public List<ForeignInfo> getJoinInfoList() {
            return this._joinInfoList;
        }

        public void addJoinInfo(ForeignInfo joinInfo) {
            if (this._joinInfoList == null) {
                this._joinInfoList = new ArrayList<ForeignInfo>();
            }
            this._joinInfoList.add(joinInfo);
        }
    }
}

