/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.mapstring;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.exception.MapListStringParseFailureException;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;

public class MapListString {
    public static final String DEFAULT_MAP_MARK = "map:";
    public static final String DEFAULT_LIST_MARK = "list:";
    public static final String DEFAULT_START_BRACE = "{";
    public static final String DEFAULT_END_BRACE = "}";
    public static final String DEFAULT_DELIMITER = ";";
    public static final String DEFAULT_EQUAL = "=";
    protected static final String ESCAPE_CHAR = "\\";
    protected static final String ESCAPED_ESCAPE_MARK = "$$df:escapedEscape$$";
    protected String _mapMark = "map:";
    protected String _listMark = "list:";
    protected String _startBrace = "{";
    protected String _endBrace = "}";
    protected String _delimiter = ";";
    protected String _equal = "=";
    protected final String _escapeChar;
    protected String _topString;
    protected String _remainderString;

    public MapListString() {
        this._escapeChar = ESCAPE_CHAR;
    }

    public String buildMapString(Map<String, ? extends Object> map) {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> casted = map;
        this.doBuildMapString(sb, casted, "", "    ");
        return sb.toString();
    }

    protected void doBuildMapString(StringBuilder sb, Map<String, Object> map, String preIndent, String curIndent) {
        sb.append(this._mapMark).append(this._startBrace);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            sb.append(this.ln()).append(curIndent).append(this._delimiter);
            sb.append(" ").append(this.escapeControlMark(key)).append(" ").append(this._equal).append(" ");
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                this.doBuildMapString(sb, valueMap, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            if (value instanceof List) {
                List valueList = (List)value;
                this.doBuildListString(sb, valueList, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            sb.append(this.escapeControlMark(value));
        }
        sb.append(this.ln()).append(preIndent).append(this._endBrace);
    }

    public String buildListString(List<? extends Object> list) {
        StringBuilder sb = new StringBuilder();
        List<? extends Object> casted = list;
        this.doBuildListString(sb, casted, "", "    ");
        return sb.toString();
    }

    protected void doBuildListString(StringBuilder sb, List<? extends Object> list, String preIndent, String curIndent) {
        sb.append(this._listMark).append(this._startBrace);
        for (Object object : list) {
            sb.append(this.ln()).append(curIndent).append(this._delimiter);
            sb.append(" ");
            if (object instanceof Map) {
                Map valueMap = (Map)object;
                this.doBuildMapString(sb, valueMap, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            if (object instanceof List) {
                List valueList = (List)object;
                this.doBuildListString(sb, valueList, curIndent, this.calculateNextIndent(preIndent, curIndent));
                continue;
            }
            sb.append(this.escapeControlMark(object));
        }
        sb.append(this.ln()).append(preIndent).append(this._endBrace);
    }

    protected String calculateNextIndent(String preIndent, String curIndent) {
        StringBuilder sb = new StringBuilder();
        int indentLength = curIndent.length() - preIndent.length();
        for (int i = 0; i < indentLength; ++i) {
            sb.append(" ");
        }
        return curIndent + sb.toString();
    }

    public Map<String, Object> generateMap(String mapString) {
        this.assertMapString(mapString);
        this._topString = mapString;
        this._remainderString = mapString;
        this.removeBothSideSpaceAndTabAndNewLine();
        this.removePrefixMapMarkAndStartBrace();
        Map<String, Object> generatedMap = this.newStringObjectMap();
        this.parseRemainderMapString(generatedMap);
        if (!"".equals(this._remainderString)) {
            this.throwMapStringUnneededStringFoundException(mapString, generatedMap);
        }
        return generatedMap;
    }

    protected void throwMapStringUnneededStringFoundException(String mapString, Map<String, Object> generatedMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Final remainderString should be empty string but ...");
        br.addItem("Remainder String");
        br.addElement(this._remainderString);
        br.addItem("Map String");
        br.addElement(mapString);
        br.addItem("Generated Map");
        br.addElement(generatedMap);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    public List<Object> generateList(String listString) {
        this.assertListString(listString);
        this._topString = listString;
        this._remainderString = listString;
        this.removeBothSideSpaceAndTabAndNewLine();
        this.removePrefixListMarkAndStartBrace();
        List<Object> generatedList = this.newObjectList();
        this.parseRemainderListString(generatedList);
        if (!"".equals(this._remainderString)) {
            this.throwListStringUnneededStringFoundException(listString, generatedList);
        }
        return generatedList;
    }

    protected void throwListStringUnneededStringFoundException(String listString, List<Object> generatedList) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Final remainderString should be empty string but ...");
        br.addItem("Remainder String");
        br.addElement(this._remainderString);
        br.addItem("List String");
        br.addElement(listString);
        br.addItem("Generated List");
        br.addElement(generatedList);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void parseRemainderMapString(Map<String, Object> currentMap) {
        String mapValue;
        int endBraceIndex;
        String mapKey;
        while (true) {
            if (this.initializeAtLoopBeginning()) {
                return;
            }
            int equalIndex = this.indexOfEqual();
            this.assertMapStringEqualIndex(this._remainderString, equalIndex, this._topString, currentMap);
            mapKey = this._remainderString.substring(0, equalIndex).trim();
            this.removePrefixTargetIndexPlus(equalIndex, this._equal.length());
            this.removeBothSideSpaceAndTabAndNewLine();
            if (this.isStartsWithMapPrefix(this._remainderString)) {
                this.removePrefixMapMarkAndStartBrace();
                this.parseRemainderMapString(this.setupNestMap(currentMap, mapKey));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            if (this.isStartsWithListPrefix(this._remainderString)) {
                this.removePrefixListMarkAndStartBrace();
                this.parseRemainderListString(this.setupNestList(currentMap, mapKey));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            int delimiterIndex = this.indexOfDelimiter();
            endBraceIndex = this.indexOfEndBrace();
            this.assertMapStringEndBraceIndex(this._remainderString, endBraceIndex, this._topString, currentMap);
            if (delimiterIndex < 0 || delimiterIndex >= endBraceIndex) break;
            mapValue = this._remainderString.substring(0, delimiterIndex);
            currentMap.put(this.filterMapListKey(mapKey), this.filterMapListValue(mapValue));
            this.removePrefixTargetIndexPlus(delimiterIndex, this._delimiter.length());
        }
        mapValue = this._remainderString.substring(0, endBraceIndex);
        currentMap.put(this.filterMapListKey(mapKey), this.filterMapListValue(mapValue));
        this.closeByEndBraceIndex(endBraceIndex);
    }

    protected void parseRemainderListString(List<Object> currentList) {
        String listValue;
        int endBraceIndex;
        while (true) {
            if (this.initializeAtLoopBeginning()) {
                return;
            }
            if (this.isStartsWithMapPrefix(this._remainderString)) {
                this.removePrefixMapMarkAndStartBrace();
                this.parseRemainderMapString(this.setupNestMap(currentList));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            if (this.isStartsWithListPrefix(this._remainderString)) {
                this.removePrefixListMarkAndStartBrace();
                this.parseRemainderListString(this.setupNestList(currentList));
                if (!this.closeAfterParseNestMapList()) continue;
                return;
            }
            int delimiterIndex = this.indexOfDelimiter();
            endBraceIndex = this.indexOfEndBrace();
            this.assertListStringEndBraceIndex(this._remainderString, endBraceIndex, this._topString, currentList);
            if (delimiterIndex < 0 || delimiterIndex >= endBraceIndex) break;
            listValue = this._remainderString.substring(0, delimiterIndex);
            currentList.add(this.filterMapListValue(listValue));
            this.removePrefixTargetIndexPlus(delimiterIndex, this._delimiter.length());
        }
        listValue = this._remainderString.substring(0, endBraceIndex);
        currentList.add(this.filterMapListValue(listValue));
        this.closeByEndBraceIndex(endBraceIndex);
    }

    protected boolean initializeAtLoopBeginning() {
        this.removePrefixAllDelimiter();
        if (this._remainderString.equals("")) {
            return true;
        }
        if (this.isStartsWithEndBrace(this._remainderString)) {
            this.removePrefixEndBrace();
            return true;
        }
        return false;
    }

    protected boolean closeAfterParseNestMapList() {
        if (this.isStartsWithEndBrace(this._remainderString)) {
            this.removePrefixEndBrace();
            return true;
        }
        return false;
    }

    protected void closeByEndBraceIndex(int endBraceIndex) {
        this._remainderString = this._remainderString.substring(endBraceIndex);
        this.removePrefixEndBrace();
    }

    protected int indexOfStartBrace() {
        return this.findIndexOfControlMark(this._remainderString, this._startBrace);
    }

    protected int indexOfEndBrace() {
        return this.findIndexOfControlMark(this._remainderString, this._endBrace);
    }

    protected int indexOfDelimiter() {
        return this.findIndexOfControlMark(this._remainderString, this._delimiter);
    }

    protected int indexOfEqual() {
        return this.findIndexOfControlMark(this._remainderString, this._equal);
    }

    protected int findIndexOfControlMark(String remainderString, String controlMark) {
        int index;
        String current = remainderString;
        if (this.isEscapeCharEscape()) {
            String escapedEscapeChar = this.toEscapedMark(this._escapeChar);
            current = this.replace(current, escapedEscapeChar, this.buildLengthSpace(escapedEscapeChar));
        }
        int baseIndex = 0;
        while (true) {
            String lastChar;
            if ((index = current.indexOf(controlMark)) < 0) {
                return index;
            }
            if (index <= 0 || !this._escapeChar.equals(lastChar = current.substring(index - 1, index))) break;
            int nextIndex = index + this._escapeChar.length();
            baseIndex += nextIndex;
            current = current.substring(nextIndex);
        }
        return baseIndex + index;
    }

    protected String buildLengthSpace(String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    protected void removePrefixMapMarkAndStartBrace() {
        this.removePrefix(this._mapMark + this._startBrace);
    }

    protected void removePrefixListMarkAndStartBrace() {
        this.removePrefix(this._listMark + this._startBrace);
    }

    protected void removePrefixDelimiter() {
        this.removePrefix(this._delimiter);
    }

    protected void removePrefixEndBrace() {
        this.removePrefix(this._endBrace);
    }

    protected void removePrefix(String prefixString) {
        String notice;
        if (this._remainderString == null) {
            notice = "The remainderString should not be null.";
            this.throwMapListStringPrefixFailureException("The remainderString should not be null.", prefixString, this._topString);
        }
        if (prefixString == null) {
            notice = "The prefixString should not be null.";
            this.throwMapListStringPrefixFailureException("The prefixString should not be null.", prefixString, this._topString);
        }
        this.removeBothSideSpaceAndTabAndNewLine();
        if (this._remainderString.length() < prefixString.length()) {
            notice = "The remainderString length shuold be greater than the prefixString length.";
            this.throwMapListStringPrefixFailureException("The remainderString length shuold be greater than the prefixString length.", prefixString, this._topString);
        }
        if (!this._remainderString.startsWith(prefixString)) {
            notice = "The remainderString shuold start with the prefixString.";
            this.throwMapListStringPrefixFailureException("The remainderString shuold start with the prefixString.", prefixString, this._topString);
        }
        this._remainderString = this._remainderString.substring(prefixString.length());
        this.removeBothSideSpaceAndTabAndNewLine();
    }

    protected void throwMapListStringPrefixFailureException(String notice, String prefixString, String mapString) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Remainder String");
        br.addElement(this._remainderString);
        br.addItem("Prefix String");
        br.addElement(prefixString);
        br.addItem("MapList String");
        br.addElement(mapString);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void removePrefixAllDelimiter() {
        this.removeBothSideSpaceAndTabAndNewLine();
        while (this.isStartsWithDelimiter(this._remainderString)) {
            if (!this.isStartsWithDelimiter(this._remainderString)) continue;
            this.removePrefixDelimiter();
            this.removeBothSideSpaceAndTabAndNewLine();
        }
    }

    protected void removeBothSideSpaceAndTabAndNewLine() {
        this._remainderString = this._remainderString.trim();
    }

    protected void removePrefixTargetIndexPlus(int index, int plusCount) {
        this._remainderString = this._remainderString.substring(index + plusCount);
    }

    protected String filterMapListKey(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return "".equals(value = this.unescapeControlMark(value)) || "null".equals(value) ? null : value;
    }

    protected String filterMapListValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        return "".equals(value = this.unescapeControlMark(value)) || "null".equals(value) ? null : value;
    }

    protected boolean isStartsWithMapPrefix(String targetString) {
        if (targetString == null) {
            String msg = "The argument 'targetString' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        targetString = targetString.trim();
        return targetString.startsWith(this.getMapPrefix());
    }

    protected String getMapPrefix() {
        return this._mapMark + this._startBrace;
    }

    protected boolean isStartsWithListPrefix(String targetString) {
        if (targetString == null) {
            String msg = "The argument 'targetString' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        targetString = targetString.trim();
        return targetString.startsWith(this._listMark + this._startBrace);
    }

    protected String getListPrefix() {
        return this._listMark + this._startBrace;
    }

    protected boolean isStartsWithDelimiter(String targetString) {
        if (targetString == null) {
            String msg = "The argument 'targetString' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        targetString = targetString.trim();
        return targetString.startsWith(this._delimiter);
    }

    protected boolean isStartsWithEndBrace(String targetString) {
        if (targetString == null) {
            String msg = "The argument 'targetString' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        targetString = targetString.trim();
        return targetString.startsWith(this._endBrace);
    }

    protected boolean isEndsWithEndBrace(String targetString) {
        if (targetString == null) {
            String msg = "The argument 'targetString' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        targetString = targetString.trim();
        return targetString.endsWith(this._endBrace);
    }

    protected Map<String, Object> setupNestMap(Map<String, Object> currentMap, String mapKey) {
        Map<String, Object> nestMap = this.newStringObjectMap();
        currentMap.put(this.filterMapListKey(mapKey), nestMap);
        return nestMap;
    }

    protected Map<String, Object> setupNestMap(List<Object> currentList) {
        Map<String, Object> nestMap = this.newStringObjectMap();
        currentList.add(nestMap);
        return nestMap;
    }

    protected List<Object> setupNestList(Map<String, Object> currentMap, String mapKey) {
        List<Object> nestList = this.newObjectList();
        currentMap.put(this.filterMapListKey(mapKey), nestList);
        return nestList;
    }

    protected List<Object> setupNestList(List<Object> currentList) {
        List<Object> nestList = this.newObjectList();
        currentList.add(nestList);
        return nestList;
    }

    protected Map<String, Object> newStringObjectMap() {
        return new LinkedHashMap<String, Object>();
    }

    protected List<Object> newObjectList() {
        return new ArrayList<Object>();
    }

    protected String escapeControlMark(Object value) {
        if (value == null) {
            return null;
        }
        String filtered = value.toString();
        if (this.isEscapeCharEscape()) {
            filtered = this.replace(filtered, this._escapeChar, this.toEscapedMark(this._escapeChar));
        }
        filtered = this.replace(filtered, this._startBrace, this.toEscapedMark(this._startBrace));
        filtered = this.replace(filtered, this._endBrace, this.toEscapedMark(this._endBrace));
        filtered = this.replace(filtered, this._delimiter, this.toEscapedMark(this._delimiter));
        filtered = this.replace(filtered, this._equal, this.toEscapedMark(this._equal));
        return filtered;
    }

    protected String unescapeControlMark(String value) {
        if (value == null) {
            return null;
        }
        String filtered = value;
        String escapedEscapeMark = ESCAPED_ESCAPE_MARK;
        if (this.isEscapeCharEscape()) {
            filtered = this.replace(filtered, this.toEscapedMark(this._escapeChar), ESCAPED_ESCAPE_MARK);
        }
        filtered = this.replace(filtered, this.toEscapedMark(this._startBrace), this._startBrace);
        filtered = this.replace(filtered, this.toEscapedMark(this._endBrace), this._endBrace);
        filtered = this.replace(filtered, this.toEscapedMark(this._delimiter), this._delimiter);
        filtered = this.replace(filtered, this.toEscapedMark(this._equal), this._equal);
        if (this.isEscapeCharEscape()) {
            filtered = this.replace(filtered, ESCAPED_ESCAPE_MARK, this._escapeChar);
        }
        return filtered;
    }

    protected String toEscapedMark(String mark) {
        return this._escapeChar + mark;
    }

    protected boolean isEscapeCharEscape() {
        return false;
    }

    protected void assertMapString(String mapString) {
        int endBraceCount;
        int startBraceCount;
        String notice;
        if (mapString == null) {
            notice = "The map string should not be null.";
            this.throwMapStringBasicFailureException("The map string should not be null.", mapString);
        }
        if (!this.isStartsWithMapPrefix(mapString = mapString.trim())) {
            notice = "The map string should start with '" + this.getMapPrefix() + "'.";
            this.throwMapStringBasicFailureException(notice, mapString);
        }
        if (!this.isEndsWithEndBrace(mapString)) {
            notice = "The map string should end with '" + this._endBrace + "'.";
            this.throwMapStringBasicFailureException(notice, mapString);
        }
        if ((startBraceCount = this.getControlMarkCount(mapString, this._startBrace)) != (endBraceCount = this.getControlMarkCount(mapString, this._endBrace))) {
            this.throwMapStringDifferentCountBracesException(mapString, startBraceCount, endBraceCount);
        }
    }

    protected void throwMapStringBasicFailureException(String notice, String mapString) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Remainder String");
        br.addElement(this._remainderString);
        br.addItem("Map String");
        br.addElement(mapString);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void throwMapStringDifferentCountBracesException(String mapString, int startCount, int endCount) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Different count between start braces and end braces.");
        br.addItem("Advice");
        br.addElement("Make sure braces on your map-list string.");
        br.addElement("For example:");
        br.addElement("  (o): map:{ foo = bar }");
        br.addElement("  (o): map:{ foo = map:{ bar = qux } }");
        br.addElement("  (x): map:{ foo = ");
        br.addElement("  (x): map:{ foo = map:{ }");
        br.addElement("");
        br.addElement("map-list string can escape control marks");
        br.addElement("so pay attention to last char of value like this:");
        br.addElement("  (x): map:{ foo = C:\\foo\\bar\\}  // last '}' escaped by escape char");
        br.addElement("  (o): map:{ foo = C:\\foo\\bar\\ } // space helps you at the case");
        br.addItem("Map String");
        br.addElement(mapString);
        br.addItem("Brace Count");
        br.addElement("start: " + startCount);
        br.addElement("end: " + endCount);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void assertListString(String listString) {
        int endBraceCount;
        int startBraceCount;
        String notice;
        if (listString == null) {
            notice = "The list string should not be null.";
            this.throwListStringBasicFailureException("The list string should not be null.", listString);
        }
        if (!this.isStartsWithListPrefix(listString = listString.trim())) {
            notice = "The list string should start with '" + this.getListPrefix() + "'.";
            this.throwListStringBasicFailureException(notice, listString);
        }
        if (!this.isEndsWithEndBrace(listString)) {
            notice = "The list string should end with '" + this._endBrace + "'.";
            this.throwListStringBasicFailureException(notice, listString);
        }
        if ((startBraceCount = this.getControlMarkCount(listString, this._startBrace)) != (endBraceCount = this.getControlMarkCount(listString, this._endBrace))) {
            this.throwListStringDifferentCountBracesException(listString, startBraceCount, endBraceCount);
        }
    }

    protected void throwListStringBasicFailureException(String notice, String listString) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Remainder String");
        br.addElement(this._remainderString);
        br.addItem("List String");
        br.addElement(listString);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void throwListStringDifferentCountBracesException(String listString, int startCount, int endCount) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Different count between start braces and end braces.");
        br.addItem("List String");
        br.addElement(listString);
        br.addItem("Brace Count");
        br.addElement("Start: " + startCount);
        br.addElement("End: " + endCount);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected int getControlMarkCount(String targetString, String controlMark) {
        int index;
        int result = 0;
        String current = targetString;
        while ((index = this.findIndexOfControlMark(current, controlMark)) >= 0) {
            ++result;
            current = current.substring(index + controlMark.length());
        }
        if (result == 0) {
            result = -1;
        }
        return result;
    }

    protected void assertMapStringEqualIndex(String remainderString, int equalIndex, String mapString, Map<String, Object> currentMap) {
        String extractedMark;
        String notice;
        if (remainderString == null) {
            notice = "The remainderString should not be null:";
            this.throwMapStringEqualFailureException("The remainderString should not be null:", remainderString, equalIndex, mapString, currentMap);
        }
        if (equalIndex < 0) {
            notice = "Not found the equal mark in the map.";
            this.throwMapStringEqualFailureException("Not found the equal mark in the map.", remainderString, equalIndex, mapString, currentMap);
        }
        if (remainderString.length() < equalIndex) {
            notice = "The remainderString length should be greater than equalIndex:";
            this.throwMapStringEqualFailureException("The remainderString length should be greater than equalIndex:", remainderString, equalIndex, mapString, currentMap);
        }
        if (!(extractedMark = remainderString.substring(equalIndex, equalIndex + this._equal.length())).equals(this._equal)) {
            String notice2 = "The remainderString should have equal mark at equalIndex:";
            this.throwMapStringEqualFailureException("The remainderString should have equal mark at equalIndex:", remainderString, equalIndex, mapString, currentMap);
        }
    }

    protected void throwMapStringEqualFailureException(String notice, String remainderMapString, int equalIndex, String mapString, Map<String, Object> currentMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Remainder String");
        br.addElement(remainderMapString);
        br.addItem("Equal Index");
        br.addElement(equalIndex);
        br.addItem("Whole Map String");
        br.addElement(mapString);
        br.addItem("Making Map");
        br.addElement(currentMap);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void assertMapStringEndBraceIndex(String remainderString, int endBraceIndex, String mapString, Map<String, Object> currentMap) {
        String extractedMark;
        String notice;
        if (remainderString == null) {
            notice = "The remainderString should not be null:";
            this.throwMapStringEndBraceFailureException("The remainderString should not be null:", remainderString, endBraceIndex, mapString, currentMap);
        }
        if (endBraceIndex < 0) {
            notice = "Not found the end brace.";
            this.throwMapStringEndBraceFailureException("Not found the end brace.", remainderString, endBraceIndex, mapString, currentMap);
        }
        if (remainderString.length() < endBraceIndex) {
            notice = "The remainderString length should be greater than endMarkIndex:";
            this.throwMapStringEndBraceFailureException("The remainderString length should be greater than endMarkIndex:", remainderString, endBraceIndex, mapString, currentMap);
        }
        if (!(extractedMark = remainderString.substring(endBraceIndex, endBraceIndex + this._endBrace.length())).equals(this._endBrace)) {
            String notice2 = "The remainderString should have end brace at the endMarkIndex:";
            this.throwMapStringEndBraceFailureException("The remainderString should have end brace at the endMarkIndex:", remainderString, endBraceIndex, mapString, currentMap);
        }
    }

    protected void assertListStringEndBraceIndex(String remainderString, int endBraceIndex, String listString, List<?> currentList) {
        String extractedMark;
        String notice;
        if (remainderString == null) {
            notice = "The remainderString should not be null:";
            this.throwListStringEndBraceFailureException("The remainderString should not be null:", remainderString, endBraceIndex, listString, currentList);
        }
        if (endBraceIndex < 0) {
            notice = "Not found the end brace.";
            this.throwListStringEndBraceFailureException("Not found the end brace.", remainderString, endBraceIndex, listString, currentList);
        }
        if (remainderString.length() < endBraceIndex) {
            notice = "The remainderString length should be greater than endMarkIndex:";
            this.throwListStringEndBraceFailureException("The remainderString length should be greater than endMarkIndex:", remainderString, endBraceIndex, listString, currentList);
        }
        if (!(extractedMark = remainderString.substring(endBraceIndex, endBraceIndex + this._endBrace.length())).equals(this._endBrace)) {
            String notice2 = "The remainderString should have end brace at the endMarkIndex:";
            this.throwListStringEndBraceFailureException("The remainderString should have end brace at the endMarkIndex:", remainderString, endBraceIndex, listString, currentList);
        }
    }

    protected void throwMapStringEndBraceFailureException(String notice, String remainderMapString, int equalIndex, String mapString, Map<String, Object> currentMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Remainder Map String");
        br.addElement(remainderMapString);
        br.addItem("EndBrace Index");
        br.addElement(equalIndex);
        br.addItem("Whole Map String");
        br.addElement(mapString);
        br.addItem("Making Map");
        br.addElement(currentMap);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void throwListStringEndBraceFailureException(String notice, String remainderMapString, int equalIndex, String listString, List<?> currentList) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Remainder List String");
        br.addElement(remainderMapString);
        br.addItem("EndBrace Index");
        br.addElement(equalIndex);
        br.addItem("Whole List String");
        br.addElement(listString);
        br.addItem("Making List");
        br.addElement(currentList);
        this.prepareControlMarkMessage(br);
        String msg = br.buildExceptionMessage();
        throw new MapListStringParseFailureException(msg);
    }

    protected void prepareControlMarkMessage(ExceptionMessageBuilder br) {
        br.addItem("Control Marks");
        br.addElement(this._startBrace + " " + this._endBrace + " " + this._delimiter + " " + this._equal);
    }

    protected String replace(String str, String fromStr, String toStr) {
        StringBuilder sb = null;
        int pos = 0;
        int pos2 = 0;
        while (true) {
            pos = str.indexOf(fromStr, pos2);
            if (pos2 == 0 && pos < 0) {
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (pos == 0) {
                sb.append(toStr);
                pos2 = fromStr.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(str.substring(pos2, pos));
            sb.append(toStr);
            pos2 = pos + fromStr.length();
        }
        sb.append(str.substring(pos2));
        return sb.toString();
    }

    protected String lnd() {
        return this.ln() + "    ";
    }

    protected String ln() {
        return "\n";
    }

    public void setMapMark(String mapMark) {
        this._mapMark = mapMark;
    }

    public void setListMark(String listMark) {
        this._listMark = listMark;
    }

    public void setStartBrace(String startBrace) {
        this._startBrace = startBrace;
    }

    public void setEndBrace(String endBrace) {
        this._endBrace = endBrace;
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public void setEqual(String equal) {
        this._equal = equal;
    }
}

